--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFirmwareStatus = {}

---@class StorageIpmiCmds.SetFirmwareStatusReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field DriveId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetFirmwareStatusReq = {}
TSetFirmwareStatusReq.__index = TSetFirmwareStatusReq
TSetFirmwareStatusReq.group = {}

local function TSetFirmwareStatusReq_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusReq)
end

function TSetFirmwareStatusReq.new(ManufacturerId, Reserve, ControllerId, DriveId, Frame, WritingOffset, WritingLength,
    Data)
    return TSetFirmwareStatusReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        DriveId = DriveId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetFirmwareStatusReq
function TSetFirmwareStatusReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.DriveId = obj.DriveId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetFirmwareStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusReq.group)
end

TSetFirmwareStatusReq.from_obj = TSetFirmwareStatusReq_from_obj

TSetFirmwareStatusReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'DriveId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetFirmwareStatusReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetFirmwareStatusReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'DriveId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetFirmwareStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveId', self.DriveId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetFirmwareStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.DriveId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetFirmwareStatus.SetFirmwareStatusReq = TSetFirmwareStatusReq

---@class StorageIpmiCmds.SetFirmwareStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetFirmwareStatusRsp = {}
TSetFirmwareStatusRsp.__index = TSetFirmwareStatusRsp
TSetFirmwareStatusRsp.group = {}

local function TSetFirmwareStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusRsp)
end

function TSetFirmwareStatusRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetFirmwareStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetFirmwareStatusRsp
function TSetFirmwareStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetFirmwareStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusRsp.group)
end

TSetFirmwareStatusRsp.from_obj = TSetFirmwareStatusRsp_from_obj

TSetFirmwareStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetFirmwareStatusRsp.default = {0, 0, 0, ''}

TSetFirmwareStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetFirmwareStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetFirmwareStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetFirmwareStatus.SetFirmwareStatusRsp = TSetFirmwareStatusRsp

return SetFirmwareStatus
