--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetControllerRestoreSettings = {}

---@class StorageIpmiCmds.SetControllerRestoreSettingsReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetControllerRestoreSettingsReq = {}
TSetControllerRestoreSettingsReq.__index = TSetControllerRestoreSettingsReq
TSetControllerRestoreSettingsReq.group = {}

local function TSetControllerRestoreSettingsReq_from_obj(obj)
    return setmetatable(obj, TSetControllerRestoreSettingsReq)
end

function TSetControllerRestoreSettingsReq.new(ManufacturerId, Reserve, ControllerId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetControllerRestoreSettingsReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerRestoreSettingsReq
function TSetControllerRestoreSettingsReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetControllerRestoreSettingsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerRestoreSettingsReq.group)
end

TSetControllerRestoreSettingsReq.from_obj = TSetControllerRestoreSettingsReq_from_obj

TSetControllerRestoreSettingsReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetControllerRestoreSettingsReq.default = {0, 0, 0, 0, 0, 0, ''}

TSetControllerRestoreSettingsReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'Frame', is_array = false, struct = nil},
    {name = 'WritingOffset', is_array = false, struct = nil}, {name = 'WritingLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerRestoreSettingsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerRestoreSettingsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerRestoreSettingsReq.proto_property, errs, need_convert)
    return self
end

function TSetControllerRestoreSettingsReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.Frame, self.WritingOffset, self.WritingLength,
        self.Data
end

SetControllerRestoreSettings.SetControllerRestoreSettingsReq = TSetControllerRestoreSettingsReq

---@class StorageIpmiCmds.SetControllerRestoreSettingsRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetControllerRestoreSettingsRsp = {}
TSetControllerRestoreSettingsRsp.__index = TSetControllerRestoreSettingsRsp
TSetControllerRestoreSettingsRsp.group = {}

local function TSetControllerRestoreSettingsRsp_from_obj(obj)
    return setmetatable(obj, TSetControllerRestoreSettingsRsp)
end

function TSetControllerRestoreSettingsRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetControllerRestoreSettingsRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerRestoreSettingsRsp
function TSetControllerRestoreSettingsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetControllerRestoreSettingsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerRestoreSettingsRsp.group)
end

TSetControllerRestoreSettingsRsp.from_obj = TSetControllerRestoreSettingsRsp_from_obj

TSetControllerRestoreSettingsRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetControllerRestoreSettingsRsp.default = {0, 0, 0, ''}

TSetControllerRestoreSettingsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerRestoreSettingsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerRestoreSettingsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerRestoreSettingsRsp.proto_property, errs, need_convert)
    return self
end

function TSetControllerRestoreSettingsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetControllerRestoreSettings.SetControllerRestoreSettingsRsp = TSetControllerRestoreSettingsRsp

return SetControllerRestoreSettings
