--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetRaidControllerTemp = {}

---@class StorageIpmiCmds.GetRaidControllerTempReq
---@field ManufacturerId integer
---@field Device integer
local TGetRaidControllerTempReq = {}
TGetRaidControllerTempReq.__index = TGetRaidControllerTempReq
TGetRaidControllerTempReq.group = {}

local function TGetRaidControllerTempReq_from_obj(obj)
    return setmetatable(obj, TGetRaidControllerTempReq)
end

function TGetRaidControllerTempReq.new(ManufacturerId, Device)
    return TGetRaidControllerTempReq_from_obj({ManufacturerId = ManufacturerId, Device = Device})
end
---@param obj StorageIpmiCmds.GetRaidControllerTempReq
function TGetRaidControllerTempReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Device = obj.Device
end

function TGetRaidControllerTempReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRaidControllerTempReq.group)
end

TGetRaidControllerTempReq.from_obj = TGetRaidControllerTempReq_from_obj

TGetRaidControllerTempReq.proto_property = {'ManufacturerId', 'Device'}

TGetRaidControllerTempReq.default = {0, 0}

TGetRaidControllerTempReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil}
}

function TGetRaidControllerTempReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)

    TGetRaidControllerTempReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRaidControllerTempReq.proto_property, errs, need_convert)
    return self
end

function TGetRaidControllerTempReq:unpack(_)
    return self.ManufacturerId, self.Device
end

GetRaidControllerTemp.GetRaidControllerTempReq = TGetRaidControllerTempReq

---@class StorageIpmiCmds.GetRaidControllerTempRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
---@field Unit integer
local TGetRaidControllerTempRsp = {}
TGetRaidControllerTempRsp.__index = TGetRaidControllerTempRsp
TGetRaidControllerTempRsp.group = {}

local function TGetRaidControllerTempRsp_from_obj(obj)
    return setmetatable(obj, TGetRaidControllerTempRsp)
end

function TGetRaidControllerTempRsp.new(CompletionCode, ManufactureId, Reading, Unit)
    return TGetRaidControllerTempRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading,
        Unit = Unit
    })
end
---@param obj StorageIpmiCmds.GetRaidControllerTempRsp
function TGetRaidControllerTempRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
    self.Unit = obj.Unit
end

function TGetRaidControllerTempRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRaidControllerTempRsp.group)
end

TGetRaidControllerTempRsp.from_obj = TGetRaidControllerTempRsp_from_obj

TGetRaidControllerTempRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading', 'Unit'}

TGetRaidControllerTempRsp.default = {0, 0, 0, 0}

TGetRaidControllerTempRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}, {name = 'Unit', is_array = false, struct = nil}
}

function TGetRaidControllerTempRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Unit', self.Unit, 'uint8', false, errs, need_convert)

    TGetRaidControllerTempRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRaidControllerTempRsp.proto_property, errs, need_convert)
    return self
end

function TGetRaidControllerTempRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading, self.Unit
end

GetRaidControllerTemp.GetRaidControllerTempRsp = TGetRaidControllerTempRsp

return GetRaidControllerTemp
