--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPhysicalDriveLedStatus = {}

---@class StorageIpmiCmds.GetPhysicalDriveLedStatusReq
---@field ManufacturerId integer
---@field Reserve integer
---@field PhysicalDriveID integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetPhysicalDriveLedStatusReq = {}
TGetPhysicalDriveLedStatusReq.__index = TGetPhysicalDriveLedStatusReq
TGetPhysicalDriveLedStatusReq.group = {}

local function TGetPhysicalDriveLedStatusReq_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveLedStatusReq)
end

function TGetPhysicalDriveLedStatusReq.new(ManufacturerId, Reserve, PhysicalDriveID, ReadingOffset, ReadingLength)
    return TGetPhysicalDriveLedStatusReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        PhysicalDriveID = PhysicalDriveID,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveLedStatusReq
function TGetPhysicalDriveLedStatusReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.PhysicalDriveID = obj.PhysicalDriveID
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetPhysicalDriveLedStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveLedStatusReq.group)
end

TGetPhysicalDriveLedStatusReq.from_obj = TGetPhysicalDriveLedStatusReq_from_obj

TGetPhysicalDriveLedStatusReq.proto_property = {
    'ManufacturerId', 'Reserve', 'PhysicalDriveID', 'ReadingOffset', 'ReadingLength'
}

TGetPhysicalDriveLedStatusReq.default = {0, 0, 0, 0, 0}

TGetPhysicalDriveLedStatusReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'PhysicalDriveID', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetPhysicalDriveLedStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PhysicalDriveID', self.PhysicalDriveID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetPhysicalDriveLedStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveLedStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveLedStatusReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.PhysicalDriveID, self.ReadingOffset, self.ReadingLength
end

GetPhysicalDriveLedStatus.GetPhysicalDriveLedStatusReq = TGetPhysicalDriveLedStatusReq

---@class StorageIpmiCmds.GetPhysicalDriveLedStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetPhysicalDriveLedStatusRsp = {}
TGetPhysicalDriveLedStatusRsp.__index = TGetPhysicalDriveLedStatusRsp
TGetPhysicalDriveLedStatusRsp.group = {}

local function TGetPhysicalDriveLedStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveLedStatusRsp)
end

function TGetPhysicalDriveLedStatusRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetPhysicalDriveLedStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveLedStatusRsp
function TGetPhysicalDriveLedStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetPhysicalDriveLedStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveLedStatusRsp.group)
end

TGetPhysicalDriveLedStatusRsp.from_obj = TGetPhysicalDriveLedStatusRsp_from_obj

TGetPhysicalDriveLedStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetPhysicalDriveLedStatusRsp.default = {0, 0, 0, ''}

TGetPhysicalDriveLedStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetPhysicalDriveLedStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPhysicalDriveLedStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveLedStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveLedStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetPhysicalDriveLedStatus.GetPhysicalDriveLedStatusRsp = TGetPhysicalDriveLedStatusRsp

return GetPhysicalDriveLedStatus
