--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLogicalDriveListEx = {}

---@class StorageIpmiCmds.GetLogicalDriveListExReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetLogicalDriveListExReq = {}
TGetLogicalDriveListExReq.__index = TGetLogicalDriveListExReq
TGetLogicalDriveListExReq.group = {}

local function TGetLogicalDriveListExReq_from_obj(obj)
    return setmetatable(obj, TGetLogicalDriveListExReq)
end

function TGetLogicalDriveListExReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetLogicalDriveListExReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetLogicalDriveListExReq
function TGetLogicalDriveListExReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetLogicalDriveListExReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDriveListExReq.group)
end

TGetLogicalDriveListExReq.from_obj = TGetLogicalDriveListExReq_from_obj

TGetLogicalDriveListExReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'
}

TGetLogicalDriveListExReq.default = {0, 0, 0, 0, 0}

TGetLogicalDriveListExReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetLogicalDriveListExReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetLogicalDriveListExReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDriveListExReq.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDriveListExReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetLogicalDriveListEx.GetLogicalDriveListExReq = TGetLogicalDriveListExReq

---@class StorageIpmiCmds.GetLogicalDriveListExRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetLogicalDriveListExRsp = {}
TGetLogicalDriveListExRsp.__index = TGetLogicalDriveListExRsp
TGetLogicalDriveListExRsp.group = {}

local function TGetLogicalDriveListExRsp_from_obj(obj)
    return setmetatable(obj, TGetLogicalDriveListExRsp)
end

function TGetLogicalDriveListExRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetLogicalDriveListExRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetLogicalDriveListExRsp
function TGetLogicalDriveListExRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetLogicalDriveListExRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDriveListExRsp.group)
end

TGetLogicalDriveListExRsp.from_obj = TGetLogicalDriveListExRsp_from_obj

TGetLogicalDriveListExRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetLogicalDriveListExRsp.default = {0, 0, 0, ''}

TGetLogicalDriveListExRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetLogicalDriveListExRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLogicalDriveListExRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDriveListExRsp.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDriveListExRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetLogicalDriveListEx.GetLogicalDriveListExRsp = TGetLogicalDriveListExRsp

return GetLogicalDriveListEx
