--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLogAutoCollectConfig = {}

---@class StorageIpmiCmds.GetLogAutoCollectConfigReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetLogAutoCollectConfigReq = {}
TGetLogAutoCollectConfigReq.__index = TGetLogAutoCollectConfigReq
TGetLogAutoCollectConfigReq.group = {}

local function TGetLogAutoCollectConfigReq_from_obj(obj)
    return setmetatable(obj, TGetLogAutoCollectConfigReq)
end

function TGetLogAutoCollectConfigReq.new(ManufacturerId, Reserve, ReadingOffset, ReadingLength)
    return TGetLogAutoCollectConfigReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetLogAutoCollectConfigReq
function TGetLogAutoCollectConfigReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetLogAutoCollectConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogAutoCollectConfigReq.group)
end

TGetLogAutoCollectConfigReq.from_obj = TGetLogAutoCollectConfigReq_from_obj

TGetLogAutoCollectConfigReq.proto_property = {'ManufacturerId', 'Reserve', 'ReadingOffset', 'ReadingLength'}

TGetLogAutoCollectConfigReq.default = {0, 0, 0, 0}

TGetLogAutoCollectConfigReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetLogAutoCollectConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetLogAutoCollectConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogAutoCollectConfigReq.proto_property, errs, need_convert)
    return self
end

function TGetLogAutoCollectConfigReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ReadingOffset, self.ReadingLength
end

GetLogAutoCollectConfig.GetLogAutoCollectConfigReq = TGetLogAutoCollectConfigReq

---@class StorageIpmiCmds.GetLogAutoCollectConfigRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field LogAutoCollectEnable integer
---@field LogAutoCollectInterval integer
local TGetLogAutoCollectConfigRsp = {}
TGetLogAutoCollectConfigRsp.__index = TGetLogAutoCollectConfigRsp
TGetLogAutoCollectConfigRsp.group = {}

local function TGetLogAutoCollectConfigRsp_from_obj(obj)
    return setmetatable(obj, TGetLogAutoCollectConfigRsp)
end

function TGetLogAutoCollectConfigRsp.new(CompletionCode, ManufactureId, Reserve, LogAutoCollectEnable,
    LogAutoCollectInterval)
    return TGetLogAutoCollectConfigRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        LogAutoCollectEnable = LogAutoCollectEnable,
        LogAutoCollectInterval = LogAutoCollectInterval
    })
end
---@param obj StorageIpmiCmds.GetLogAutoCollectConfigRsp
function TGetLogAutoCollectConfigRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.LogAutoCollectEnable = obj.LogAutoCollectEnable
    self.LogAutoCollectInterval = obj.LogAutoCollectInterval
end

function TGetLogAutoCollectConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogAutoCollectConfigRsp.group)
end

TGetLogAutoCollectConfigRsp.from_obj = TGetLogAutoCollectConfigRsp_from_obj

TGetLogAutoCollectConfigRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'Reserve', 'LogAutoCollectEnable', 'LogAutoCollectInterval'
}

TGetLogAutoCollectConfigRsp.default = {0, 0, 0, 0, 0}

TGetLogAutoCollectConfigRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'LogAutoCollectEnable', is_array = false, struct = nil},
    {name = 'LogAutoCollectInterval', is_array = false, struct = nil}
}

function TGetLogAutoCollectConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LogAutoCollectEnable', self.LogAutoCollectEnable, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LogAutoCollectInterval', self.LogAutoCollectInterval, 'uint8', false, errs,
        need_convert)

    TGetLogAutoCollectConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogAutoCollectConfigRsp.proto_property, errs, need_convert)
    return self
end

function TGetLogAutoCollectConfigRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.LogAutoCollectEnable, self.LogAutoCollectInterval
end

GetLogAutoCollectConfig.GetLogAutoCollectConfigRsp = TGetLogAutoCollectConfigRsp

return GetLogAutoCollectConfig
