--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLdDedicatedSparedPds = {}

---@class StorageIpmiCmds.GetLdDedicatedSparedPdsReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetLdDedicatedSparedPdsReq = {}
TGetLdDedicatedSparedPdsReq.__index = TGetLdDedicatedSparedPdsReq
TGetLdDedicatedSparedPdsReq.group = {}

local function TGetLdDedicatedSparedPdsReq_from_obj(obj)
    return setmetatable(obj, TGetLdDedicatedSparedPdsReq)
end

function TGetLdDedicatedSparedPdsReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, ReadingOffset, ReadingLength)
    return TGetLdDedicatedSparedPdsReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetLdDedicatedSparedPdsReq
function TGetLdDedicatedSparedPdsReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetLdDedicatedSparedPdsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdDedicatedSparedPdsReq.group)
end

TGetLdDedicatedSparedPdsReq.from_obj = TGetLdDedicatedSparedPdsReq_from_obj

TGetLdDedicatedSparedPdsReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'ReadingOffset', 'ReadingLength'
}

TGetLdDedicatedSparedPdsReq.default = {0, 0, 0, 0, 0, 0}

TGetLdDedicatedSparedPdsReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetLdDedicatedSparedPdsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetLdDedicatedSparedPdsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdDedicatedSparedPdsReq.proto_property, errs, need_convert)
    return self
end

function TGetLdDedicatedSparedPdsReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.ReadingOffset, self.ReadingLength
end

GetLdDedicatedSparedPds.GetLdDedicatedSparedPdsReq = TGetLdDedicatedSparedPdsReq

---@class StorageIpmiCmds.GetLdDedicatedSparedPdsRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetLdDedicatedSparedPdsRsp = {}
TGetLdDedicatedSparedPdsRsp.__index = TGetLdDedicatedSparedPdsRsp
TGetLdDedicatedSparedPdsRsp.group = {}

local function TGetLdDedicatedSparedPdsRsp_from_obj(obj)
    return setmetatable(obj, TGetLdDedicatedSparedPdsRsp)
end

function TGetLdDedicatedSparedPdsRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetLdDedicatedSparedPdsRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetLdDedicatedSparedPdsRsp
function TGetLdDedicatedSparedPdsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetLdDedicatedSparedPdsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLdDedicatedSparedPdsRsp.group)
end

TGetLdDedicatedSparedPdsRsp.from_obj = TGetLdDedicatedSparedPdsRsp_from_obj

TGetLdDedicatedSparedPdsRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetLdDedicatedSparedPdsRsp.default = {0, 0, 0, ''}

TGetLdDedicatedSparedPdsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetLdDedicatedSparedPdsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLdDedicatedSparedPdsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLdDedicatedSparedPdsRsp.proto_property, errs, need_convert)
    return self
end

function TGetLdDedicatedSparedPdsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetLdDedicatedSparedPds.GetLdDedicatedSparedPdsRsp = TGetLdDedicatedSparedPdsRsp

return GetLdDedicatedSparedPds
