--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDiskManufacturer = {}

---@class StorageIpmiCmds.GetDiskManufacturerReq
---@field ManufactureId integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDiskManufacturerReq = {}
TGetDiskManufacturerReq.__index = TGetDiskManufacturerReq
TGetDiskManufacturerReq.group = {}

local function TGetDiskManufacturerReq_from_obj(obj)
    return setmetatable(obj, TGetDiskManufacturerReq)
end

function TGetDiskManufacturerReq.new(ManufactureId, DeviceNumber, ReadOffset, Length)
    return TGetDiskManufacturerReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj StorageIpmiCmds.GetDiskManufacturerReq
function TGetDiskManufacturerReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDiskManufacturerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiskManufacturerReq.group)
end

TGetDiskManufacturerReq.from_obj = TGetDiskManufacturerReq_from_obj

TGetDiskManufacturerReq.proto_property = {'ManufactureId', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDiskManufacturerReq.default = {0, 0, 0, 0}

TGetDiskManufacturerReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceNumber', is_array = false, struct = nil},
    {name = 'ReadOffset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDiskManufacturerReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDiskManufacturerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiskManufacturerReq.proto_property, errs, need_convert)
    return self
end

function TGetDiskManufacturerReq:unpack(_)
    return self.ManufactureId, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDiskManufacturer.GetDiskManufacturerReq = TGetDiskManufacturerReq

---@class StorageIpmiCmds.GetDiskManufacturerRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDiskManufacturerRsp = {}
TGetDiskManufacturerRsp.__index = TGetDiskManufacturerRsp
TGetDiskManufacturerRsp.group = {}

local function TGetDiskManufacturerRsp_from_obj(obj)
    return setmetatable(obj, TGetDiskManufacturerRsp)
end

function TGetDiskManufacturerRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDiskManufacturerRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetDiskManufacturerRsp
function TGetDiskManufacturerRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDiskManufacturerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiskManufacturerRsp.group)
end

TGetDiskManufacturerRsp.from_obj = TGetDiskManufacturerRsp_from_obj

TGetDiskManufacturerRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDiskManufacturerRsp.default = {0, 0, 0, ''}

TGetDiskManufacturerRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDiskManufacturerRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDiskManufacturerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiskManufacturerRsp.proto_property, errs, need_convert)
    return self
end

function TGetDiskManufacturerRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDiskManufacturer.GetDiskManufacturerRsp = TGetDiskManufacturerRsp

return GetDiskManufacturer
