--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerList = {}

---@class StorageIpmiCmds.GetControllerListReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerListReq = {}
TGetControllerListReq.__index = TGetControllerListReq
TGetControllerListReq.group = {}

local function TGetControllerListReq_from_obj(obj)
    return setmetatable(obj, TGetControllerListReq)
end

function TGetControllerListReq.new(ManufacturerId, Reserve, ReadingOffset, ReadingLength)
    return TGetControllerListReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerListReq
function TGetControllerListReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerListReq.group)
end

TGetControllerListReq.from_obj = TGetControllerListReq_from_obj

TGetControllerListReq.proto_property = {'ManufacturerId', 'Reserve', 'ReadingOffset', 'ReadingLength'}

TGetControllerListReq.default = {0, 0, 0, 0}

TGetControllerListReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerListReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerListReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ReadingOffset, self.ReadingLength
end

GetControllerList.GetControllerListReq = TGetControllerListReq

---@class StorageIpmiCmds.GetControllerListRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerListRsp = {}
TGetControllerListRsp.__index = TGetControllerListRsp
TGetControllerListRsp.group = {}

local function TGetControllerListRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerListRsp)
end

function TGetControllerListRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerListRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerListRsp
function TGetControllerListRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerListRsp.group)
end

TGetControllerListRsp.from_obj = TGetControllerListRsp_from_obj

TGetControllerListRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerListRsp.default = {0, 0, 0, ''}

TGetControllerListRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerListRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerListRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerList.GetControllerListRsp = TGetControllerListRsp

return GetControllerList
