--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerFwVersion = {}

---@class StorageIpmiCmds.GetControllerFwVersionReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerFwVersionReq = {}
TGetControllerFwVersionReq.__index = TGetControllerFwVersionReq
TGetControllerFwVersionReq.group = {}

local function TGetControllerFwVersionReq_from_obj(obj)
    return setmetatable(obj, TGetControllerFwVersionReq)
end

function TGetControllerFwVersionReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetControllerFwVersionReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerFwVersionReq
function TGetControllerFwVersionReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerFwVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerFwVersionReq.group)
end

TGetControllerFwVersionReq.from_obj = TGetControllerFwVersionReq_from_obj

TGetControllerFwVersionReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'
}

TGetControllerFwVersionReq.default = {0, 0, 0, 0, 0}

TGetControllerFwVersionReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerFwVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerFwVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerFwVersionReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerFwVersionReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetControllerFwVersion.GetControllerFwVersionReq = TGetControllerFwVersionReq

---@class StorageIpmiCmds.GetControllerFwVersionRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerFwVersionRsp = {}
TGetControllerFwVersionRsp.__index = TGetControllerFwVersionRsp
TGetControllerFwVersionRsp.group = {}

local function TGetControllerFwVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerFwVersionRsp)
end

function TGetControllerFwVersionRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerFwVersionRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerFwVersionRsp
function TGetControllerFwVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerFwVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerFwVersionRsp.group)
end

TGetControllerFwVersionRsp.from_obj = TGetControllerFwVersionRsp_from_obj

TGetControllerFwVersionRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerFwVersionRsp.default = {0, 0, 0, ''}

TGetControllerFwVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerFwVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerFwVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerFwVersionRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerFwVersionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerFwVersion.GetControllerFwVersionRsp = TGetControllerFwVersionRsp

return GetControllerFwVersion
