--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCachecadeAssociatedLds = {}

---@class StorageIpmiCmds.GetCachecadeAssociatedLdsReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field CachecadeID integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetCachecadeAssociatedLdsReq = {}
TGetCachecadeAssociatedLdsReq.__index = TGetCachecadeAssociatedLdsReq
TGetCachecadeAssociatedLdsReq.group = {}

local function TGetCachecadeAssociatedLdsReq_from_obj(obj)
    return setmetatable(obj, TGetCachecadeAssociatedLdsReq)
end

function TGetCachecadeAssociatedLdsReq.new(ManufacturerId, Reserve, ControllerId, CachecadeID, ReadingOffset,
    ReadingLength)
    return TGetCachecadeAssociatedLdsReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        CachecadeID = CachecadeID,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetCachecadeAssociatedLdsReq
function TGetCachecadeAssociatedLdsReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.CachecadeID = obj.CachecadeID
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetCachecadeAssociatedLdsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachecadeAssociatedLdsReq.group)
end

TGetCachecadeAssociatedLdsReq.from_obj = TGetCachecadeAssociatedLdsReq_from_obj

TGetCachecadeAssociatedLdsReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'CachecadeID', 'ReadingOffset', 'ReadingLength'
}

TGetCachecadeAssociatedLdsReq.default = {0, 0, 0, 0, 0, 0}

TGetCachecadeAssociatedLdsReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'CachecadeID', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetCachecadeAssociatedLdsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CachecadeID', self.CachecadeID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetCachecadeAssociatedLdsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachecadeAssociatedLdsReq.proto_property, errs, need_convert)
    return self
end

function TGetCachecadeAssociatedLdsReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.CachecadeID, self.ReadingOffset,
        self.ReadingLength
end

GetCachecadeAssociatedLds.GetCachecadeAssociatedLdsReq = TGetCachecadeAssociatedLdsReq

---@class StorageIpmiCmds.GetCachecadeAssociatedLdsRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetCachecadeAssociatedLdsRsp = {}
TGetCachecadeAssociatedLdsRsp.__index = TGetCachecadeAssociatedLdsRsp
TGetCachecadeAssociatedLdsRsp.group = {}

local function TGetCachecadeAssociatedLdsRsp_from_obj(obj)
    return setmetatable(obj, TGetCachecadeAssociatedLdsRsp)
end

function TGetCachecadeAssociatedLdsRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetCachecadeAssociatedLdsRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetCachecadeAssociatedLdsRsp
function TGetCachecadeAssociatedLdsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetCachecadeAssociatedLdsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachecadeAssociatedLdsRsp.group)
end

TGetCachecadeAssociatedLdsRsp.from_obj = TGetCachecadeAssociatedLdsRsp_from_obj

TGetCachecadeAssociatedLdsRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetCachecadeAssociatedLdsRsp.default = {0, 0, 0, ''}

TGetCachecadeAssociatedLdsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetCachecadeAssociatedLdsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetCachecadeAssociatedLdsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachecadeAssociatedLdsRsp.proto_property, errs, need_convert)
    return self
end

function TGetCachecadeAssociatedLdsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetCachecadeAssociatedLds.GetCachecadeAssociatedLdsRsp = TGetCachecadeAssociatedLdsRsp

return GetCachecadeAssociatedLds
