-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = {}

---@class def_types.Configuration
---@field UID string
---@field SlotId integer[]
---@field SystemId integer[]
local TConfiguration = {}
TConfiguration.__index = TConfiguration
TConfiguration.group = {}

local function TConfiguration_from_obj(obj)
    return setmetatable(obj, TConfiguration)
end

function TConfiguration.new(UID, SlotId, SystemId)
    return TConfiguration_from_obj({UID = UID, SlotId = SlotId, SystemId = SystemId})
end
---@param obj def_types.Configuration
function TConfiguration:init_from_obj(obj)
    self.UID = obj.UID
    self.SlotId = obj.SlotId
    self.SystemId = obj.SystemId
end

function TConfiguration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfiguration.group)
end

TConfiguration.from_obj = TConfiguration_from_obj

TConfiguration.proto_property = {'UID', 'SlotId', 'SystemId'}

TConfiguration.default = {'', {}, {}}

TConfiguration.struct = {
    {name = 'UID', is_array = false, struct = nil}, {name = 'SlotId', is_array = true, struct = nil},
    {name = 'SystemId', is_array = true, struct = nil}
}

function TConfiguration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TConfiguration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfiguration.proto_property, errs, need_convert)
    return self
end

function TConfiguration:unpack(_)
    return self.UID, self.SlotId, self.SystemId
end

def_types.Configuration = TConfiguration

return def_types
