-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MNVMeConfig = {}

---@class MNVMeConfig.MultiHostMappings
---@field MultiHostMappings def_types.Configuration[]
local TMultiHostMappings = {}
TMultiHostMappings.__index = TMultiHostMappings
TMultiHostMappings.group = {}

local function TMultiHostMappings_from_obj(obj)
    obj.MultiHostMappings = utils.from_obj(def_types.Configuration, obj.MultiHostMappings, true)
    return setmetatable(obj, TMultiHostMappings)
end

function TMultiHostMappings.new(MultiHostMappings)
    return TMultiHostMappings_from_obj({MultiHostMappings = MultiHostMappings})
end
---@param obj MNVMeConfig.MultiHostMappings
function TMultiHostMappings:init_from_obj(obj)
    self.MultiHostMappings = obj.MultiHostMappings
end

function TMultiHostMappings:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiHostMappings.group)
end

TMultiHostMappings.from_obj = TMultiHostMappings_from_obj

TMultiHostMappings.proto_property = {'MultiHostMappings'}

TMultiHostMappings.default = {{}}

TMultiHostMappings.struct = {{name = 'MultiHostMappings', is_array = true, struct = def_types.Configuration.struct}}

function TMultiHostMappings:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.MultiHostMappings) do
        def_types.Configuration.new(v.UID, v.SlotId, v.SystemId):validate(prefix, errs, need_convert)
    end

    TMultiHostMappings:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiHostMappings.proto_property, errs, need_convert)
    return self
end

function TMultiHostMappings:unpack(raw)
    return utils.unpack(raw, self.MultiHostMappings, true)
end

MNVMeConfig.MultiHostMappings = TMultiHostMappings

return MNVMeConfig
