-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDrive = {}

---@class MDrive.UnexpectedSenseTimes
---@field UnexpectedSenseTimes integer
local TUnexpectedSenseTimes = {}
TUnexpectedSenseTimes.__index = TUnexpectedSenseTimes
TUnexpectedSenseTimes.group = {}

local function TUnexpectedSenseTimes_from_obj(obj)
    return setmetatable(obj, TUnexpectedSenseTimes)
end

function TUnexpectedSenseTimes.new(UnexpectedSenseTimes)
    return TUnexpectedSenseTimes_from_obj({UnexpectedSenseTimes = UnexpectedSenseTimes or 0})
end
---@param obj MDrive.UnexpectedSenseTimes
function TUnexpectedSenseTimes:init_from_obj(obj)
    self.UnexpectedSenseTimes = obj.UnexpectedSenseTimes or 0
end

function TUnexpectedSenseTimes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnexpectedSenseTimes.group)
end

TUnexpectedSenseTimes.from_obj = TUnexpectedSenseTimes_from_obj

TUnexpectedSenseTimes.proto_property = {'UnexpectedSenseTimes'}

TUnexpectedSenseTimes.default = {0}

TUnexpectedSenseTimes.struct = {{name = 'UnexpectedSenseTimes', is_array = false, struct = nil}}

function TUnexpectedSenseTimes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnexpectedSenseTimes', self.UnexpectedSenseTimes, 'uint32', false, errs, need_convert)

    TUnexpectedSenseTimes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnexpectedSenseTimes.proto_property, errs, need_convert)
    return self
end

function TUnexpectedSenseTimes:unpack(_)
    return self.UnexpectedSenseTimes
end

MDrive.UnexpectedSenseTimes = TUnexpectedSenseTimes

---@class MDrive.CommandTimeoutTimes
---@field CommandTimeoutTimes integer
local TCommandTimeoutTimes = {}
TCommandTimeoutTimes.__index = TCommandTimeoutTimes
TCommandTimeoutTimes.group = {}

local function TCommandTimeoutTimes_from_obj(obj)
    return setmetatable(obj, TCommandTimeoutTimes)
end

function TCommandTimeoutTimes.new(CommandTimeoutTimes)
    return TCommandTimeoutTimes_from_obj({CommandTimeoutTimes = CommandTimeoutTimes or 0})
end
---@param obj MDrive.CommandTimeoutTimes
function TCommandTimeoutTimes:init_from_obj(obj)
    self.CommandTimeoutTimes = obj.CommandTimeoutTimes or 0
end

function TCommandTimeoutTimes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCommandTimeoutTimes.group)
end

TCommandTimeoutTimes.from_obj = TCommandTimeoutTimes_from_obj

TCommandTimeoutTimes.proto_property = {'CommandTimeoutTimes'}

TCommandTimeoutTimes.default = {0}

TCommandTimeoutTimes.struct = {{name = 'CommandTimeoutTimes', is_array = false, struct = nil}}

function TCommandTimeoutTimes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CommandTimeoutTimes', self.CommandTimeoutTimes, 'uint32', false, errs, need_convert)

    TCommandTimeoutTimes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCommandTimeoutTimes.proto_property, errs, need_convert)
    return self
end

function TCommandTimeoutTimes:unpack(_)
    return self.CommandTimeoutTimes
end

MDrive.CommandTimeoutTimes = TCommandTimeoutTimes

---@class MDrive.SetFaultLed
---@field SetFaultLed integer
local TSetFaultLed = {}
TSetFaultLed.__index = TSetFaultLed
TSetFaultLed.group = {}

local function TSetFaultLed_from_obj(obj)
    return setmetatable(obj, TSetFaultLed)
end

function TSetFaultLed.new(SetFaultLed)
    return TSetFaultLed_from_obj({SetFaultLed = SetFaultLed})
end
---@param obj MDrive.SetFaultLed
function TSetFaultLed:init_from_obj(obj)
    self.SetFaultLed = obj.SetFaultLed
end

function TSetFaultLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultLed.group)
end

TSetFaultLed.from_obj = TSetFaultLed_from_obj

TSetFaultLed.proto_property = {'SetFaultLed'}

TSetFaultLed.default = {0}

TSetFaultLed.struct = {{name = 'SetFaultLed', is_array = false, struct = nil}}

function TSetFaultLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetFaultLed', self.SetFaultLed, 'uint8', false, errs, need_convert)

    TSetFaultLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultLed.proto_property, errs, need_convert)
    return self
end

function TSetFaultLed:unpack(_)
    return self.SetFaultLed
end

MDrive.SetFaultLed = TSetFaultLed

---@class MDrive.SetLocateLed
---@field SetLocateLed integer
local TSetLocateLed = {}
TSetLocateLed.__index = TSetLocateLed
TSetLocateLed.group = {}

local function TSetLocateLed_from_obj(obj)
    return setmetatable(obj, TSetLocateLed)
end

function TSetLocateLed.new(SetLocateLed)
    return TSetLocateLed_from_obj({SetLocateLed = SetLocateLed})
end
---@param obj MDrive.SetLocateLed
function TSetLocateLed:init_from_obj(obj)
    self.SetLocateLed = obj.SetLocateLed
end

function TSetLocateLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocateLed.group)
end

TSetLocateLed.from_obj = TSetLocateLed_from_obj

TSetLocateLed.proto_property = {'SetLocateLed'}

TSetLocateLed.default = {0}

TSetLocateLed.struct = {{name = 'SetLocateLed', is_array = false, struct = nil}}

function TSetLocateLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetLocateLed', self.SetLocateLed, 'uint8', false, errs, need_convert)

    TSetLocateLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocateLed.proto_property, errs, need_convert)
    return self
end

function TSetLocateLed:unpack(_)
    return self.SetLocateLed
end

MDrive.SetLocateLed = TSetLocateLed

---@class MDrive.LinkFault
---@field LinkFault boolean
local TLinkFault = {}
TLinkFault.__index = TLinkFault
TLinkFault.group = {}

local function TLinkFault_from_obj(obj)
    return setmetatable(obj, TLinkFault)
end

function TLinkFault.new(LinkFault)
    return TLinkFault_from_obj({LinkFault = LinkFault or false})
end
---@param obj MDrive.LinkFault
function TLinkFault:init_from_obj(obj)
    self.LinkFault = obj.LinkFault or false
end

function TLinkFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkFault.group)
end

TLinkFault.from_obj = TLinkFault_from_obj

TLinkFault.proto_property = {'LinkFault'}

TLinkFault.default = {false}

TLinkFault.struct = {{name = 'LinkFault', is_array = false, struct = nil}}

function TLinkFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkFault', self.LinkFault, 'bool', false, errs, need_convert)

    TLinkFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkFault.proto_property, errs, need_convert)
    return self
end

function TLinkFault:unpack(_)
    return self.LinkFault
end

MDrive.LinkFault = TLinkFault

---@class MDrive.RelativeSlot
---@field RelativeSlot integer
local TRelativeSlot = {}
TRelativeSlot.__index = TRelativeSlot
TRelativeSlot.group = {}

local function TRelativeSlot_from_obj(obj)
    return setmetatable(obj, TRelativeSlot)
end

function TRelativeSlot.new(RelativeSlot)
    return TRelativeSlot_from_obj({RelativeSlot = RelativeSlot})
end
---@param obj MDrive.RelativeSlot
function TRelativeSlot:init_from_obj(obj)
    self.RelativeSlot = obj.RelativeSlot
end

function TRelativeSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelativeSlot.group)
end

TRelativeSlot.from_obj = TRelativeSlot_from_obj

TRelativeSlot.proto_property = {'RelativeSlot'}

TRelativeSlot.default = {0}

TRelativeSlot.struct = {{name = 'RelativeSlot', is_array = false, struct = nil}}

function TRelativeSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RelativeSlot', self.RelativeSlot, 'uint8', false, errs, need_convert)

    TRelativeSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelativeSlot.proto_property, errs, need_convert)
    return self
end

function TRelativeSlot:unpack(_)
    return self.RelativeSlot
end

MDrive.RelativeSlot = TRelativeSlot

---@class MDrive.HddBackplaneStartSlot
---@field HddBackplaneStartSlot integer
local THddBackplaneStartSlot = {}
THddBackplaneStartSlot.__index = THddBackplaneStartSlot
THddBackplaneStartSlot.group = {}

local function THddBackplaneStartSlot_from_obj(obj)
    return setmetatable(obj, THddBackplaneStartSlot)
end

function THddBackplaneStartSlot.new(HddBackplaneStartSlot)
    return THddBackplaneStartSlot_from_obj({HddBackplaneStartSlot = HddBackplaneStartSlot or 255})
end
---@param obj MDrive.HddBackplaneStartSlot
function THddBackplaneStartSlot:init_from_obj(obj)
    self.HddBackplaneStartSlot = obj.HddBackplaneStartSlot or 255
end

function THddBackplaneStartSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THddBackplaneStartSlot.group)
end

THddBackplaneStartSlot.from_obj = THddBackplaneStartSlot_from_obj

THddBackplaneStartSlot.proto_property = {'HddBackplaneStartSlot'}

THddBackplaneStartSlot.default = {0}

THddBackplaneStartSlot.struct = {{name = 'HddBackplaneStartSlot', is_array = false, struct = nil}}

function THddBackplaneStartSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HddBackplaneStartSlot', self.HddBackplaneStartSlot, 'uint8', false, errs, need_convert)

    THddBackplaneStartSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THddBackplaneStartSlot.proto_property, errs, need_convert)
    return self
end

function THddBackplaneStartSlot:unpack(_)
    return self.HddBackplaneStartSlot
end

MDrive.HddBackplaneStartSlot = THddBackplaneStartSlot

---@class MDrive.PassThrough
---@field PassThrough integer
local TPassThrough = {}
TPassThrough.__index = TPassThrough
TPassThrough.group = {}

local function TPassThrough_from_obj(obj)
    return setmetatable(obj, TPassThrough)
end

function TPassThrough.new(PassThrough)
    return TPassThrough_from_obj({PassThrough = PassThrough or 255})
end
---@param obj MDrive.PassThrough
function TPassThrough:init_from_obj(obj)
    self.PassThrough = obj.PassThrough or 255
end

function TPassThrough:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPassThrough.group)
end

TPassThrough.from_obj = TPassThrough_from_obj

TPassThrough.proto_property = {'PassThrough'}

TPassThrough.default = {0}

TPassThrough.struct = {{name = 'PassThrough', is_array = false, struct = nil}}

function TPassThrough:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PassThrough', self.PassThrough, 'uint8', false, errs, need_convert)

    TPassThrough:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPassThrough.proto_property, errs, need_convert)
    return self
end

function TPassThrough:unpack(_)
    return self.PassThrough
end

MDrive.PassThrough = TPassThrough

---@class MDrive.PhysicalLocation
---@field PhysicalLocation string
local TPhysicalLocation = {}
TPhysicalLocation.__index = TPhysicalLocation
TPhysicalLocation.group = {}

local function TPhysicalLocation_from_obj(obj)
    return setmetatable(obj, TPhysicalLocation)
end

function TPhysicalLocation.new(PhysicalLocation)
    return TPhysicalLocation_from_obj({PhysicalLocation = PhysicalLocation})
end
---@param obj MDrive.PhysicalLocation
function TPhysicalLocation:init_from_obj(obj)
    self.PhysicalLocation = obj.PhysicalLocation
end

function TPhysicalLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalLocation.group)
end

TPhysicalLocation.from_obj = TPhysicalLocation_from_obj

TPhysicalLocation.proto_property = {'PhysicalLocation'}

TPhysicalLocation.default = {''}

TPhysicalLocation.struct = {{name = 'PhysicalLocation', is_array = false, struct = nil}}

function TPhysicalLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalLocation', self.PhysicalLocation, 'string', false, errs, need_convert)

    TPhysicalLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalLocation.proto_property, errs, need_convert)
    return self
end

function TPhysicalLocation:unpack(_)
    return self.PhysicalLocation
end

MDrive.PhysicalLocation = TPhysicalLocation

---@class MDrive.ActivationLed
---@field ActivationLed integer
local TActivationLed = {}
TActivationLed.__index = TActivationLed
TActivationLed.group = {}

local function TActivationLed_from_obj(obj)
    return setmetatable(obj, TActivationLed)
end

function TActivationLed.new(ActivationLed)
    return TActivationLed_from_obj({ActivationLed = ActivationLed})
end
---@param obj MDrive.ActivationLed
function TActivationLed:init_from_obj(obj)
    self.ActivationLed = obj.ActivationLed
end

function TActivationLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivationLed.group)
end

TActivationLed.from_obj = TActivationLed_from_obj

TActivationLed.proto_property = {'ActivationLed'}

TActivationLed.default = {0}

TActivationLed.struct = {{name = 'ActivationLed', is_array = false, struct = nil}}

function TActivationLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActivationLed', self.ActivationLed, 'uint8', false, errs, need_convert)

    TActivationLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivationLed.proto_property, errs, need_convert)
    return self
end

function TActivationLed:unpack(_)
    return self.ActivationLed
end

MDrive.ActivationLed = TActivationLed

---@class MDrive.FaultReg
---@field FaultReg integer
local TFaultReg = {}
TFaultReg.__index = TFaultReg
TFaultReg.group = {}

local function TFaultReg_from_obj(obj)
    return setmetatable(obj, TFaultReg)
end

function TFaultReg.new(FaultReg)
    return TFaultReg_from_obj({FaultReg = FaultReg})
end
---@param obj MDrive.FaultReg
function TFaultReg:init_from_obj(obj)
    self.FaultReg = obj.FaultReg
end

function TFaultReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultReg.group)
end

TFaultReg.from_obj = TFaultReg_from_obj

TFaultReg.proto_property = {'FaultReg'}

TFaultReg.default = {0}

TFaultReg.struct = {{name = 'FaultReg', is_array = false, struct = nil}}

function TFaultReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultReg', self.FaultReg, 'uint8', false, errs, need_convert)

    TFaultReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultReg.proto_property, errs, need_convert)
    return self
end

function TFaultReg:unpack(_)
    return self.FaultReg
end

MDrive.FaultReg = TFaultReg

---@class MDrive.LocateReg
---@field LocateReg integer
local TLocateReg = {}
TLocateReg.__index = TLocateReg
TLocateReg.group = {}

local function TLocateReg_from_obj(obj)
    return setmetatable(obj, TLocateReg)
end

function TLocateReg.new(LocateReg)
    return TLocateReg_from_obj({LocateReg = LocateReg})
end
---@param obj MDrive.LocateReg
function TLocateReg:init_from_obj(obj)
    self.LocateReg = obj.LocateReg
end

function TLocateReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocateReg.group)
end

TLocateReg.from_obj = TLocateReg_from_obj

TLocateReg.proto_property = {'LocateReg'}

TLocateReg.default = {0}

TLocateReg.struct = {{name = 'LocateReg', is_array = false, struct = nil}}

function TLocateReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocateReg', self.LocateReg, 'uint8', false, errs, need_convert)

    TLocateReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocateReg.proto_property, errs, need_convert)
    return self
end

function TLocateReg:unpack(_)
    return self.LocateReg
end

MDrive.LocateReg = TLocateReg

return MDrive
