-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local sensor_instance = require 'sensor.sensor_instance'

test_sensor_instance = {}

function test_sensor_instance.test_recover_sensor_status()
    local sel = {}

    -- 打桩过程方法
    sensor_instance.sel_sigs = {
        get = {
            emit = function () return {sel} end
        },
        remove = { emit = function () end },
        post = { emit = function () end }
    }
    sensor_instance.entity_sigs = {
        getName = {
            emit = function () return 'MainBoard' end
        }
    }
    sensor_instance.mdb_obj = {
        SensorType = 0x28,
        ReadingType = 0x6F,
        SensorNumber = 0x01,
        SensorName = 'Mngmnt Health'
    }

    -- 调用主流程方法
    sensor_instance.recover_sensor_status(sensor_instance)

    -- 校验结果
    lu.assertEquals(sel.SensorNumber, 0x01)
    lu.assertEquals(sel.SensorName, 'Mngmnt Health')
    lu.assertEquals(sel.SubjectName, 'MainBoard')
    lu.assertEquals(sel.EventDir, 1)
end

return test_sensor_instance