-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local test_data = {}

test_data.t_ipmi_sel_list = {
    {
        RecordId = 1,
        SelType = 1,
        Timestamp = 0x12345678,
        GenerateId = 1,
        SelMsgVersion = 4,
        SensorType = 1,
        SensorNumber = 1,
        SelEventType = 1,
        SelData1 = 0x51,
        SelData2 = 0x00,
        SelData3 = 0x00,
        SensorId = 'Test1Temp_1'
    }
}

test_data.t_pef_filter = {
    {
        Configuration = 128,
        Action = 1,
        PolicyNumber = 1,
        Severity = 0,
        GeneratorId1 = 255,
        GeneratorId2 = 255,
        SensorType = 255,
        SensorNumber = 255,
        EventTrigger = 255,
        OffsetMask = 65535,
        Event1AndMask = 0,
        Event1Compare1 = 255,
        Event1Compare2 = 0,
        Event2AndMask = 0,
        Event2Compare1 = 255,
        Event2Compare2 = 0,
        Event3AndMask = 0,
        Event3Compare1 = 255,
        Event3Compare2 = 0
    }
}

test_data.t_alert_filter = {
    {PolicyNum = 24, Destination = 17, AlertString = 0},
    {PolicyNum = 24, Destination = 18, AlertString = 0},
    {PolicyNum = 24, Destination = 19, AlertString = 0}
}

test_data.t_alert_string = {
    {Id = 1, FilterNumber = 0, StringSet = 0, AlertString = [=[]=]},
    {Id = 2, FilterNumber = 0, StringSet = 0, AlertString = [=[]=]}
}

test_data.t_ipmi_sel_filters = {
    {SensorType = 1, ReadingType = 1, FilterMask1 = 2708, FilterMask2 = 65535, FilterMask3 = 65535},
    {SensorType = 1, ReadingType = 7, FilterMask1 = 6, FilterMask2 = 65535, FilterMask3 = 65535},
    {SensorType = 2, ReadingType = 1, FilterMask1 = 2709, FilterMask2 = 65535, FilterMask3 = 65535},
    {SensorType = 4, ReadingType = 1, FilterMask1 = 2580, FilterMask2 = 65535, FilterMask3 = 65535},
    {SensorType = 5, ReadingType = 111, FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535},
}

test_data.t_ipmi_sel_descs = {
    {
        SensorType = 255,
        ReadingType = 127,
        SelData1 = 15,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 0,
        SelDesc = [=[Unknown Sensor Event Description]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 1,
        SelDesc = [=[Lower Non-critical going low ]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 1,
        SelDesc = [=[Lower Non-critical going high]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 2,
        SelDesc = [=[Lower Critical going low ]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 2,
        SelDesc = [=[Lower Critical going high]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 3,
        SelDesc = [=[Lower Non-recoverable going low ]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 3,
        SelDesc = [=[Lower Non-recoverable going high]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 1,
        SelDesc = [=[Upper Non-critical going low ]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 1,
        SelDesc = [=[Upper Non-critical going high]=]
    }, {
        SensorType = 1,
        ReadingType = 1,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        ShieldFlag = 0,
        AlarmLevel = 2,
        SelDesc = [=[Upper Critical going low ]=]
    }
}

return test_data