-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThresholdSensorDisplay = {}

---@class ThresholdSensorDisplay.AssertStatus
---@field AssertStatus integer
local TAssertStatus = {}
TAssertStatus.__index = TAssertStatus
TAssertStatus.group = {}

local function TAssertStatus_from_obj(obj)
    return setmetatable(obj, TAssertStatus)
end

function TAssertStatus.new(AssertStatus)
    return TAssertStatus_from_obj({AssertStatus = AssertStatus})
end
---@param obj ThresholdSensorDisplay.AssertStatus
function TAssertStatus:init_from_obj(obj)
    self.AssertStatus = obj.AssertStatus
end

function TAssertStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssertStatus.group)
end

TAssertStatus.from_obj = TAssertStatus_from_obj

TAssertStatus.proto_property = {'AssertStatus'}

TAssertStatus.default = {0}

TAssertStatus.struct = {{name = 'AssertStatus', is_array = false, struct = nil}}

function TAssertStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssertStatus', self.AssertStatus, 'uint16', true, errs, need_convert)

    TAssertStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssertStatus.proto_property, errs, need_convert)
    return self
end

function TAssertStatus:unpack(_)
    return self.AssertStatus
end

ThresholdSensorDisplay.AssertStatus = TAssertStatus

---@class ThresholdSensorDisplay.Health
---@field Health string
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj ThresholdSensorDisplay.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {''}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'string', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

ThresholdSensorDisplay.Health = THealth

---@class ThresholdSensorDisplay.Status
---@field Status string
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj ThresholdSensorDisplay.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {''}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

ThresholdSensorDisplay.Status = TStatus

---@class ThresholdSensorDisplay.UnitDisplay
---@field UnitDisplay string
local TUnitDisplay = {}
TUnitDisplay.__index = TUnitDisplay
TUnitDisplay.group = {}

local function TUnitDisplay_from_obj(obj)
    return setmetatable(obj, TUnitDisplay)
end

function TUnitDisplay.new(UnitDisplay)
    return TUnitDisplay_from_obj({UnitDisplay = UnitDisplay})
end
---@param obj ThresholdSensorDisplay.UnitDisplay
function TUnitDisplay:init_from_obj(obj)
    self.UnitDisplay = obj.UnitDisplay
end

function TUnitDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnitDisplay.group)
end

TUnitDisplay.from_obj = TUnitDisplay_from_obj

TUnitDisplay.proto_property = {'UnitDisplay'}

TUnitDisplay.default = {''}

TUnitDisplay.struct = {{name = 'UnitDisplay', is_array = false, struct = nil}}

function TUnitDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnitDisplay', self.UnitDisplay, 'string', true, errs, need_convert)

    TUnitDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnitDisplay.proto_property, errs, need_convert)
    return self
end

function TUnitDisplay:unpack(_)
    return self.UnitDisplay
end

ThresholdSensorDisplay.UnitDisplay = TUnitDisplay

---@class ThresholdSensorDisplay.ReadingDisplay
---@field ReadingDisplay string
local TReadingDisplay = {}
TReadingDisplay.__index = TReadingDisplay
TReadingDisplay.group = {}

local function TReadingDisplay_from_obj(obj)
    return setmetatable(obj, TReadingDisplay)
end

function TReadingDisplay.new(ReadingDisplay)
    return TReadingDisplay_from_obj({ReadingDisplay = ReadingDisplay})
end
---@param obj ThresholdSensorDisplay.ReadingDisplay
function TReadingDisplay:init_from_obj(obj)
    self.ReadingDisplay = obj.ReadingDisplay
end

function TReadingDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingDisplay.group)
end

TReadingDisplay.from_obj = TReadingDisplay_from_obj

TReadingDisplay.proto_property = {'ReadingDisplay'}

TReadingDisplay.default = {''}

TReadingDisplay.struct = {{name = 'ReadingDisplay', is_array = false, struct = nil}}

function TReadingDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingDisplay', self.ReadingDisplay, 'string', false, errs, need_convert)

    TReadingDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingDisplay.proto_property, errs, need_convert)
    return self
end

function TReadingDisplay:unpack(_)
    return self.ReadingDisplay
end

ThresholdSensorDisplay.ReadingDisplay = TReadingDisplay

---@class ThresholdSensorDisplay.NegativeHysteresisDisplay
---@field NegativeHysteresisDisplay string
local TNegativeHysteresisDisplay = {}
TNegativeHysteresisDisplay.__index = TNegativeHysteresisDisplay
TNegativeHysteresisDisplay.group = {}

local function TNegativeHysteresisDisplay_from_obj(obj)
    return setmetatable(obj, TNegativeHysteresisDisplay)
end

function TNegativeHysteresisDisplay.new(NegativeHysteresisDisplay)
    return TNegativeHysteresisDisplay_from_obj({NegativeHysteresisDisplay = NegativeHysteresisDisplay})
end
---@param obj ThresholdSensorDisplay.NegativeHysteresisDisplay
function TNegativeHysteresisDisplay:init_from_obj(obj)
    self.NegativeHysteresisDisplay = obj.NegativeHysteresisDisplay
end

function TNegativeHysteresisDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNegativeHysteresisDisplay.group)
end

TNegativeHysteresisDisplay.from_obj = TNegativeHysteresisDisplay_from_obj

TNegativeHysteresisDisplay.proto_property = {'NegativeHysteresisDisplay'}

TNegativeHysteresisDisplay.default = {''}

TNegativeHysteresisDisplay.struct = {{name = 'NegativeHysteresisDisplay', is_array = false, struct = nil}}

function TNegativeHysteresisDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NegativeHysteresisDisplay', self.NegativeHysteresisDisplay, 'string', true, errs,
        need_convert)

    TNegativeHysteresisDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNegativeHysteresisDisplay.proto_property, errs, need_convert)
    return self
end

function TNegativeHysteresisDisplay:unpack(_)
    return self.NegativeHysteresisDisplay
end

ThresholdSensorDisplay.NegativeHysteresisDisplay = TNegativeHysteresisDisplay

---@class ThresholdSensorDisplay.PositiveHysteresisDisplay
---@field PositiveHysteresisDisplay string
local TPositiveHysteresisDisplay = {}
TPositiveHysteresisDisplay.__index = TPositiveHysteresisDisplay
TPositiveHysteresisDisplay.group = {}

local function TPositiveHysteresisDisplay_from_obj(obj)
    return setmetatable(obj, TPositiveHysteresisDisplay)
end

function TPositiveHysteresisDisplay.new(PositiveHysteresisDisplay)
    return TPositiveHysteresisDisplay_from_obj({PositiveHysteresisDisplay = PositiveHysteresisDisplay})
end
---@param obj ThresholdSensorDisplay.PositiveHysteresisDisplay
function TPositiveHysteresisDisplay:init_from_obj(obj)
    self.PositiveHysteresisDisplay = obj.PositiveHysteresisDisplay
end

function TPositiveHysteresisDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPositiveHysteresisDisplay.group)
end

TPositiveHysteresisDisplay.from_obj = TPositiveHysteresisDisplay_from_obj

TPositiveHysteresisDisplay.proto_property = {'PositiveHysteresisDisplay'}

TPositiveHysteresisDisplay.default = {''}

TPositiveHysteresisDisplay.struct = {{name = 'PositiveHysteresisDisplay', is_array = false, struct = nil}}

function TPositiveHysteresisDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PositiveHysteresisDisplay', self.PositiveHysteresisDisplay, 'string', true, errs,
        need_convert)

    TPositiveHysteresisDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPositiveHysteresisDisplay.proto_property, errs, need_convert)
    return self
end

function TPositiveHysteresisDisplay:unpack(_)
    return self.PositiveHysteresisDisplay
end

ThresholdSensorDisplay.PositiveHysteresisDisplay = TPositiveHysteresisDisplay

---@class ThresholdSensorDisplay.LowerCriticalDisplay
---@field LowerCriticalDisplay string
local TLowerCriticalDisplay = {}
TLowerCriticalDisplay.__index = TLowerCriticalDisplay
TLowerCriticalDisplay.group = {}

local function TLowerCriticalDisplay_from_obj(obj)
    return setmetatable(obj, TLowerCriticalDisplay)
end

function TLowerCriticalDisplay.new(LowerCriticalDisplay)
    return TLowerCriticalDisplay_from_obj({LowerCriticalDisplay = LowerCriticalDisplay})
end
---@param obj ThresholdSensorDisplay.LowerCriticalDisplay
function TLowerCriticalDisplay:init_from_obj(obj)
    self.LowerCriticalDisplay = obj.LowerCriticalDisplay
end

function TLowerCriticalDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerCriticalDisplay.group)
end

TLowerCriticalDisplay.from_obj = TLowerCriticalDisplay_from_obj

TLowerCriticalDisplay.proto_property = {'LowerCriticalDisplay'}

TLowerCriticalDisplay.default = {''}

TLowerCriticalDisplay.struct = {{name = 'LowerCriticalDisplay', is_array = false, struct = nil}}

function TLowerCriticalDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerCriticalDisplay', self.LowerCriticalDisplay, 'string', true, errs, need_convert)

    TLowerCriticalDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerCriticalDisplay.proto_property, errs, need_convert)
    return self
end

function TLowerCriticalDisplay:unpack(_)
    return self.LowerCriticalDisplay
end

ThresholdSensorDisplay.LowerCriticalDisplay = TLowerCriticalDisplay

---@class ThresholdSensorDisplay.LowerNoncriticalDisplay
---@field LowerNoncriticalDisplay string
local TLowerNoncriticalDisplay = {}
TLowerNoncriticalDisplay.__index = TLowerNoncriticalDisplay
TLowerNoncriticalDisplay.group = {}

local function TLowerNoncriticalDisplay_from_obj(obj)
    return setmetatable(obj, TLowerNoncriticalDisplay)
end

function TLowerNoncriticalDisplay.new(LowerNoncriticalDisplay)
    return TLowerNoncriticalDisplay_from_obj({LowerNoncriticalDisplay = LowerNoncriticalDisplay})
end
---@param obj ThresholdSensorDisplay.LowerNoncriticalDisplay
function TLowerNoncriticalDisplay:init_from_obj(obj)
    self.LowerNoncriticalDisplay = obj.LowerNoncriticalDisplay
end

function TLowerNoncriticalDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerNoncriticalDisplay.group)
end

TLowerNoncriticalDisplay.from_obj = TLowerNoncriticalDisplay_from_obj

TLowerNoncriticalDisplay.proto_property = {'LowerNoncriticalDisplay'}

TLowerNoncriticalDisplay.default = {''}

TLowerNoncriticalDisplay.struct = {{name = 'LowerNoncriticalDisplay', is_array = false, struct = nil}}

function TLowerNoncriticalDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerNoncriticalDisplay', self.LowerNoncriticalDisplay, 'string', true, errs,
        need_convert)

    TLowerNoncriticalDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerNoncriticalDisplay.proto_property, errs, need_convert)
    return self
end

function TLowerNoncriticalDisplay:unpack(_)
    return self.LowerNoncriticalDisplay
end

ThresholdSensorDisplay.LowerNoncriticalDisplay = TLowerNoncriticalDisplay

---@class ThresholdSensorDisplay.LowerNonrecoverableDisplay
---@field LowerNonrecoverableDisplay string
local TLowerNonrecoverableDisplay = {}
TLowerNonrecoverableDisplay.__index = TLowerNonrecoverableDisplay
TLowerNonrecoverableDisplay.group = {}

local function TLowerNonrecoverableDisplay_from_obj(obj)
    return setmetatable(obj, TLowerNonrecoverableDisplay)
end

function TLowerNonrecoverableDisplay.new(LowerNonrecoverableDisplay)
    return TLowerNonrecoverableDisplay_from_obj({LowerNonrecoverableDisplay = LowerNonrecoverableDisplay})
end
---@param obj ThresholdSensorDisplay.LowerNonrecoverableDisplay
function TLowerNonrecoverableDisplay:init_from_obj(obj)
    self.LowerNonrecoverableDisplay = obj.LowerNonrecoverableDisplay
end

function TLowerNonrecoverableDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerNonrecoverableDisplay.group)
end

TLowerNonrecoverableDisplay.from_obj = TLowerNonrecoverableDisplay_from_obj

TLowerNonrecoverableDisplay.proto_property = {'LowerNonrecoverableDisplay'}

TLowerNonrecoverableDisplay.default = {''}

TLowerNonrecoverableDisplay.struct = {{name = 'LowerNonrecoverableDisplay', is_array = false, struct = nil}}

function TLowerNonrecoverableDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerNonrecoverableDisplay', self.LowerNonrecoverableDisplay, 'string', true, errs,
        need_convert)

    TLowerNonrecoverableDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerNonrecoverableDisplay.proto_property, errs, need_convert)
    return self
end

function TLowerNonrecoverableDisplay:unpack(_)
    return self.LowerNonrecoverableDisplay
end

ThresholdSensorDisplay.LowerNonrecoverableDisplay = TLowerNonrecoverableDisplay

---@class ThresholdSensorDisplay.UpperNoncriticalDisplay
---@field UpperNoncriticalDisplay string
local TUpperNoncriticalDisplay = {}
TUpperNoncriticalDisplay.__index = TUpperNoncriticalDisplay
TUpperNoncriticalDisplay.group = {}

local function TUpperNoncriticalDisplay_from_obj(obj)
    return setmetatable(obj, TUpperNoncriticalDisplay)
end

function TUpperNoncriticalDisplay.new(UpperNoncriticalDisplay)
    return TUpperNoncriticalDisplay_from_obj({UpperNoncriticalDisplay = UpperNoncriticalDisplay})
end
---@param obj ThresholdSensorDisplay.UpperNoncriticalDisplay
function TUpperNoncriticalDisplay:init_from_obj(obj)
    self.UpperNoncriticalDisplay = obj.UpperNoncriticalDisplay
end

function TUpperNoncriticalDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperNoncriticalDisplay.group)
end

TUpperNoncriticalDisplay.from_obj = TUpperNoncriticalDisplay_from_obj

TUpperNoncriticalDisplay.proto_property = {'UpperNoncriticalDisplay'}

TUpperNoncriticalDisplay.default = {''}

TUpperNoncriticalDisplay.struct = {{name = 'UpperNoncriticalDisplay', is_array = false, struct = nil}}

function TUpperNoncriticalDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperNoncriticalDisplay', self.UpperNoncriticalDisplay, 'string', true, errs,
        need_convert)

    TUpperNoncriticalDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperNoncriticalDisplay.proto_property, errs, need_convert)
    return self
end

function TUpperNoncriticalDisplay:unpack(_)
    return self.UpperNoncriticalDisplay
end

ThresholdSensorDisplay.UpperNoncriticalDisplay = TUpperNoncriticalDisplay

---@class ThresholdSensorDisplay.UpperCriticalDisplay
---@field UpperCriticalDisplay string
local TUpperCriticalDisplay = {}
TUpperCriticalDisplay.__index = TUpperCriticalDisplay
TUpperCriticalDisplay.group = {}

local function TUpperCriticalDisplay_from_obj(obj)
    return setmetatable(obj, TUpperCriticalDisplay)
end

function TUpperCriticalDisplay.new(UpperCriticalDisplay)
    return TUpperCriticalDisplay_from_obj({UpperCriticalDisplay = UpperCriticalDisplay})
end
---@param obj ThresholdSensorDisplay.UpperCriticalDisplay
function TUpperCriticalDisplay:init_from_obj(obj)
    self.UpperCriticalDisplay = obj.UpperCriticalDisplay
end

function TUpperCriticalDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperCriticalDisplay.group)
end

TUpperCriticalDisplay.from_obj = TUpperCriticalDisplay_from_obj

TUpperCriticalDisplay.proto_property = {'UpperCriticalDisplay'}

TUpperCriticalDisplay.default = {''}

TUpperCriticalDisplay.struct = {{name = 'UpperCriticalDisplay', is_array = false, struct = nil}}

function TUpperCriticalDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperCriticalDisplay', self.UpperCriticalDisplay, 'string', true, errs, need_convert)

    TUpperCriticalDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperCriticalDisplay.proto_property, errs, need_convert)
    return self
end

function TUpperCriticalDisplay:unpack(_)
    return self.UpperCriticalDisplay
end

ThresholdSensorDisplay.UpperCriticalDisplay = TUpperCriticalDisplay

---@class ThresholdSensorDisplay.UpperNonrecoverableDisplay
---@field UpperNonrecoverableDisplay string
local TUpperNonrecoverableDisplay = {}
TUpperNonrecoverableDisplay.__index = TUpperNonrecoverableDisplay
TUpperNonrecoverableDisplay.group = {}

local function TUpperNonrecoverableDisplay_from_obj(obj)
    return setmetatable(obj, TUpperNonrecoverableDisplay)
end

function TUpperNonrecoverableDisplay.new(UpperNonrecoverableDisplay)
    return TUpperNonrecoverableDisplay_from_obj({UpperNonrecoverableDisplay = UpperNonrecoverableDisplay})
end
---@param obj ThresholdSensorDisplay.UpperNonrecoverableDisplay
function TUpperNonrecoverableDisplay:init_from_obj(obj)
    self.UpperNonrecoverableDisplay = obj.UpperNonrecoverableDisplay
end

function TUpperNonrecoverableDisplay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperNonrecoverableDisplay.group)
end

TUpperNonrecoverableDisplay.from_obj = TUpperNonrecoverableDisplay_from_obj

TUpperNonrecoverableDisplay.proto_property = {'UpperNonrecoverableDisplay'}

TUpperNonrecoverableDisplay.default = {''}

TUpperNonrecoverableDisplay.struct = {{name = 'UpperNonrecoverableDisplay', is_array = false, struct = nil}}

function TUpperNonrecoverableDisplay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperNonrecoverableDisplay', self.UpperNonrecoverableDisplay, 'string', true, errs,
        need_convert)

    TUpperNonrecoverableDisplay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperNonrecoverableDisplay.proto_property, errs, need_convert)
    return self
end

function TUpperNonrecoverableDisplay:unpack(_)
    return self.UpperNonrecoverableDisplay
end

ThresholdSensorDisplay.UpperNonrecoverableDisplay = TUpperNonrecoverableDisplay

ThresholdSensorDisplay.interface = mdb.register_interface('bmc.kepler.Systems.ThresholdSensorDisplay', {
    UpperNonrecoverableDisplay = {'s', {}, true, nil},
    UpperCriticalDisplay = {'s', {}, true, nil},
    UpperNoncriticalDisplay = {'s', {}, true, nil},
    LowerNonrecoverableDisplay = {'s', {}, true, nil},
    LowerNoncriticalDisplay = {'s', {}, true, nil},
    LowerCriticalDisplay = {'s', {}, true, nil},
    PositiveHysteresisDisplay = {'s', {}, true, nil},
    NegativeHysteresisDisplay = {'s', {}, true, nil},
    ReadingDisplay = {'s', {'VOLATILE'}, false, nil},
    UnitDisplay = {'s', {'CONST'}, true, nil},
    Status = {'s', {'EMIT_CHANGE'}, true, nil},
    Health = {'s', nil, true, nil},
    AssertStatus = {'q', {}, true, nil}
}, {}, {})

return ThresholdSensorDisplay
