-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SensorSelInfo = {}

---@class SensorSelInfo.RecordSeq
---@field RecordSeq integer
local TRecordSeq = {}
TRecordSeq.__index = TRecordSeq
TRecordSeq.group = {}

local function TRecordSeq_from_obj(obj)
    return setmetatable(obj, TRecordSeq)
end

function TRecordSeq.new(RecordSeq)
    return TRecordSeq_from_obj({RecordSeq = RecordSeq})
end
---@param obj SensorSelInfo.RecordSeq
function TRecordSeq:init_from_obj(obj)
    self.RecordSeq = obj.RecordSeq
end

function TRecordSeq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecordSeq.group)
end

TRecordSeq.from_obj = TRecordSeq_from_obj

TRecordSeq.proto_property = {'RecordSeq'}

TRecordSeq.default = {0}

TRecordSeq.struct = {{name = 'RecordSeq', is_array = false, struct = nil}}

function TRecordSeq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RecordSeq', self.RecordSeq, 'uint64', true, errs, need_convert)

    TRecordSeq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecordSeq.proto_property, errs, need_convert)
    return self
end

function TRecordSeq:unpack(_)
    return self.RecordSeq
end

SensorSelInfo.RecordSeq = TRecordSeq

---@class SensorSelInfo.SelMode
---@field SelMode integer
local TSelMode = {}
TSelMode.__index = TSelMode
TSelMode.group = {}

local function TSelMode_from_obj(obj)
    return setmetatable(obj, TSelMode)
end

function TSelMode.new(SelMode)
    return TSelMode_from_obj({SelMode = SelMode})
end
---@param obj SensorSelInfo.SelMode
function TSelMode:init_from_obj(obj)
    self.SelMode = obj.SelMode
end

function TSelMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelMode.group)
end

TSelMode.from_obj = TSelMode_from_obj

TSelMode.proto_property = {'SelMode'}

TSelMode.default = {0}

TSelMode.struct = {{name = 'SelMode', is_array = false, struct = nil}}

function TSelMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelMode', self.SelMode, 'uint8', false, errs, need_convert)

    TSelMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelMode.proto_property, errs, need_convert)
    return self
end

function TSelMode:unpack(_)
    return self.SelMode
end

SensorSelInfo.SelMode = TSelMode

SensorSelInfo.interface = mdb.register_interface('bmc.kepler.Chassis.SensorSelInfo',
    {SelMode = {'y', nil, false, nil}, RecordSeq = {'t', nil, true, nil}}, {}, {})

return SensorSelInfo
