-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fru = {}

Fru.interface = mdb.register_interface('bmc.kepler.Systems.Fru', {
    PcbId = {'y', nil, true, nil},
    PcbVersion = {'s', nil, true, nil},
    FruId = {'y', nil, true, nil},
    FruName = {'s', nil, true, nil},
    PowerState = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Health = {'y', nil, true, nil},
    EepStatus = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    GroupPosition = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Type = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    FruDataId = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    BoardId = {'q', nil, true, nil},
    UniqueId = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ConnectorGroupId = {'u', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return Fru
