-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiscreteEvent = {}

---@class DiscreteEvent.SensorObject
---@field SensorObject string
local TSensorObject = {}
TSensorObject.__index = TSensorObject
TSensorObject.group = {}

local function TSensorObject_from_obj(obj)
    return setmetatable(obj, TSensorObject)
end

function TSensorObject.new(SensorObject)
    return TSensorObject_from_obj({SensorObject = SensorObject})
end
---@param obj DiscreteEvent.SensorObject
function TSensorObject:init_from_obj(obj)
    self.SensorObject = obj.SensorObject
end

function TSensorObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorObject.group)
end

TSensorObject.from_obj = TSensorObject_from_obj

TSensorObject.proto_property = {'SensorObject'}

TSensorObject.default = {''}

TSensorObject.struct = {{name = 'SensorObject', is_array = false, struct = nil}}

function TSensorObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorObject', self.SensorObject, 'string', true, errs, need_convert)

    TSensorObject:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorObject.proto_property, errs, need_convert)
    return self
end

function TSensorObject:unpack(_)
    return self.SensorObject
end

DiscreteEvent.SensorObject = TSensorObject

---@class DiscreteEvent.EventDir
---@field EventDir integer
local TEventDir = {}
TEventDir.__index = TEventDir
TEventDir.group = {}

local function TEventDir_from_obj(obj)
    return setmetatable(obj, TEventDir)
end

function TEventDir.new(EventDir)
    return TEventDir_from_obj({EventDir = EventDir})
end
---@param obj DiscreteEvent.EventDir
function TEventDir:init_from_obj(obj)
    self.EventDir = obj.EventDir
end

function TEventDir:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventDir.group)
end

TEventDir.from_obj = TEventDir_from_obj

TEventDir.proto_property = {'EventDir'}

TEventDir.default = {0}

TEventDir.struct = {{name = 'EventDir', is_array = false, struct = nil}}

function TEventDir:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', true, errs, need_convert)

    TEventDir:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventDir.proto_property, errs, need_convert)
    return self
end

function TEventDir:unpack(_)
    return self.EventDir
end

DiscreteEvent.EventDir = TEventDir

---@class DiscreteEvent.Property
---@field Property integer
local TProperty = {}
TProperty.__index = TProperty
TProperty.group = {}

local function TProperty_from_obj(obj)
    return setmetatable(obj, TProperty)
end

function TProperty.new(Property)
    return TProperty_from_obj({Property = Property})
end
---@param obj DiscreteEvent.Property
function TProperty:init_from_obj(obj)
    self.Property = obj.Property
end

function TProperty:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProperty.group)
end

TProperty.from_obj = TProperty_from_obj

TProperty.proto_property = {'Property'}

TProperty.default = {0}

TProperty.struct = {{name = 'Property', is_array = false, struct = nil}}

function TProperty:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Property', self.Property, 'uint32', true, errs, need_convert)

    TProperty:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProperty.proto_property, errs, need_convert)
    return self
end

function TProperty:unpack(_)
    return self.Property
end

DiscreteEvent.Property = TProperty

DiscreteEvent.interface = mdb.register_interface('bmc.kepler.Systems.DiscreteEvent', {
    Property = {'u', {}, true, nil},
    EventDir = {'y', {}, true, nil},
    SensorObject = {'s', {}, true, nil}
}, {}, {})

return DiscreteEvent
