--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPEFParameters = {}

---@class SensorIpmiCmds.SetPEFParametersReq
---@field Datas string
local TSetPEFParametersReq = {}
TSetPEFParametersReq.__index = TSetPEFParametersReq
TSetPEFParametersReq.group = {}

local function TSetPEFParametersReq_from_obj(obj)
    return setmetatable(obj, TSetPEFParametersReq)
end

function TSetPEFParametersReq.new(Datas)
    return TSetPEFParametersReq_from_obj({Datas = Datas})
end
---@param obj SensorIpmiCmds.SetPEFParametersReq
function TSetPEFParametersReq:init_from_obj(obj)
    self.Datas = obj.Datas
end

function TSetPEFParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFParametersReq.group)
end

TSetPEFParametersReq.from_obj = TSetPEFParametersReq_from_obj

TSetPEFParametersReq.proto_property = {'Datas'}

TSetPEFParametersReq.default = {''}

TSetPEFParametersReq.struct = {{name = 'Datas', is_array = false, struct = nil}}

function TSetPEFParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TSetPEFParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFParametersReq.proto_property, errs, need_convert)
    return self
end

function TSetPEFParametersReq:unpack(_)
    return self.Datas
end

SetPEFParameters.SetPEFParametersReq = TSetPEFParametersReq

---@class SensorIpmiCmds.SetPEFParametersRsp
---@field CompletionCode integer
local TSetPEFParametersRsp = {}
TSetPEFParametersRsp.__index = TSetPEFParametersRsp
TSetPEFParametersRsp.group = {}

local function TSetPEFParametersRsp_from_obj(obj)
    return setmetatable(obj, TSetPEFParametersRsp)
end

function TSetPEFParametersRsp.new(CompletionCode)
    return TSetPEFParametersRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetPEFParametersRsp
function TSetPEFParametersRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPEFParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFParametersRsp.group)
end

TSetPEFParametersRsp.from_obj = TSetPEFParametersRsp_from_obj

TSetPEFParametersRsp.proto_property = {'CompletionCode'}

TSetPEFParametersRsp.default = {0}

TSetPEFParametersRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPEFParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPEFParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFParametersRsp.proto_property, errs, need_convert)
    return self
end

function TSetPEFParametersRsp:unpack(_)
    return self.CompletionCode
end

SetPEFParameters.SetPEFParametersRsp = TSetPEFParametersRsp

return SetPEFParameters
