--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTemperatureReadings = {}

---@class SensorIpmiCmds.GetTemperatureReadingsReq
---@field SensorType integer
---@field EntityID integer
---@field EntityInstance integer
---@field EntityInstanceStart integer
local TGetTemperatureReadingsReq = {}
TGetTemperatureReadingsReq.__index = TGetTemperatureReadingsReq
TGetTemperatureReadingsReq.group = {}

local function TGetTemperatureReadingsReq_from_obj(obj)
    return setmetatable(obj, TGetTemperatureReadingsReq)
end

function TGetTemperatureReadingsReq.new(SensorType, EntityID, EntityInstance, EntityInstanceStart)
    return TGetTemperatureReadingsReq_from_obj({
        SensorType = SensorType,
        EntityID = EntityID,
        EntityInstance = EntityInstance,
        EntityInstanceStart = EntityInstanceStart
    })
end
---@param obj SensorIpmiCmds.GetTemperatureReadingsReq
function TGetTemperatureReadingsReq:init_from_obj(obj)
    self.SensorType = obj.SensorType
    self.EntityID = obj.EntityID
    self.EntityInstance = obj.EntityInstance
    self.EntityInstanceStart = obj.EntityInstanceStart
end

function TGetTemperatureReadingsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTemperatureReadingsReq.group)
end

TGetTemperatureReadingsReq.from_obj = TGetTemperatureReadingsReq_from_obj

TGetTemperatureReadingsReq.proto_property = {'SensorType', 'EntityID', 'EntityInstance', 'EntityInstanceStart'}

TGetTemperatureReadingsReq.default = {0, 0, 0, 0}

TGetTemperatureReadingsReq.struct = {
    {name = 'SensorType', is_array = false, struct = nil}, {name = 'EntityID', is_array = false, struct = nil},
    {name = 'EntityInstance', is_array = false, struct = nil},
    {name = 'EntityInstanceStart', is_array = false, struct = nil}
}

function TGetTemperatureReadingsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EntityID', self.EntityID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EntityInstance', self.EntityInstance, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EntityInstanceStart', self.EntityInstanceStart, 'uint8', false, errs, need_convert)

    TGetTemperatureReadingsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTemperatureReadingsReq.proto_property, errs, need_convert)
    return self
end

function TGetTemperatureReadingsReq:unpack(_)
    return self.SensorType, self.EntityID, self.EntityInstance, self.EntityInstanceStart
end

GetTemperatureReadings.GetTemperatureReadingsReq = TGetTemperatureReadingsReq

---@class SensorIpmiCmds.GetTemperatureReadingsRsp
---@field CompletionCode integer
---@field AvailableInstances integer
---@field TempDataCount integer
---@field TempData string
local TGetTemperatureReadingsRsp = {}
TGetTemperatureReadingsRsp.__index = TGetTemperatureReadingsRsp
TGetTemperatureReadingsRsp.group = {}

local function TGetTemperatureReadingsRsp_from_obj(obj)
    return setmetatable(obj, TGetTemperatureReadingsRsp)
end

function TGetTemperatureReadingsRsp.new(CompletionCode, AvailableInstances, TempDataCount, TempData)
    return TGetTemperatureReadingsRsp_from_obj({
        CompletionCode = CompletionCode,
        AvailableInstances = AvailableInstances,
        TempDataCount = TempDataCount,
        TempData = TempData
    })
end
---@param obj SensorIpmiCmds.GetTemperatureReadingsRsp
function TGetTemperatureReadingsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.AvailableInstances = obj.AvailableInstances
    self.TempDataCount = obj.TempDataCount
    self.TempData = obj.TempData
end

function TGetTemperatureReadingsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTemperatureReadingsRsp.group)
end

TGetTemperatureReadingsRsp.from_obj = TGetTemperatureReadingsRsp_from_obj

TGetTemperatureReadingsRsp.proto_property = {'CompletionCode', 'AvailableInstances', 'TempDataCount', 'TempData'}

TGetTemperatureReadingsRsp.default = {0, 0, 0, ''}

TGetTemperatureReadingsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'AvailableInstances', is_array = false, struct = nil},
    {name = 'TempDataCount', is_array = false, struct = nil}, {name = 'TempData', is_array = false, struct = nil}
}

function TGetTemperatureReadingsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AvailableInstances', self.AvailableInstances, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TempDataCount', self.TempDataCount, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TempData', self.TempData, 'string', false, errs, need_convert)

    TGetTemperatureReadingsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTemperatureReadingsRsp.proto_property, errs, need_convert)
    return self
end

function TGetTemperatureReadingsRsp:unpack(_)
    return self.CompletionCode, self.AvailableInstances, self.TempDataCount, self.TempData
end

GetTemperatureReadings.GetTemperatureReadingsRsp = TGetTemperatureReadingsRsp

return GetTemperatureReadings
