--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorFactors = {}

---@class SensorIpmiCmds.GetSensorFactorsReq
---@field Number integer
---@field ReadingByte integer
local TGetSensorFactorsReq = {}
TGetSensorFactorsReq.__index = TGetSensorFactorsReq
TGetSensorFactorsReq.group = {}

local function TGetSensorFactorsReq_from_obj(obj)
    return setmetatable(obj, TGetSensorFactorsReq)
end

function TGetSensorFactorsReq.new(Number, ReadingByte)
    return TGetSensorFactorsReq_from_obj({Number = Number, ReadingByte = ReadingByte})
end
---@param obj SensorIpmiCmds.GetSensorFactorsReq
function TGetSensorFactorsReq:init_from_obj(obj)
    self.Number = obj.Number
    self.ReadingByte = obj.ReadingByte
end

function TGetSensorFactorsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorFactorsReq.group)
end

TGetSensorFactorsReq.from_obj = TGetSensorFactorsReq_from_obj

TGetSensorFactorsReq.proto_property = {'Number', 'ReadingByte'}

TGetSensorFactorsReq.default = {0, 0}

TGetSensorFactorsReq.struct = {
    {name = 'Number', is_array = false, struct = nil}, {name = 'ReadingByte', is_array = false, struct = nil}
}

function TGetSensorFactorsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingByte', self.ReadingByte, 'uint8', false, errs, need_convert)

    TGetSensorFactorsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorFactorsReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorFactorsReq:unpack(_)
    return self.Number, self.ReadingByte
end

GetSensorFactors.GetSensorFactorsReq = TGetSensorFactorsReq

---@class SensorIpmiCmds.GetSensorFactorsRsp
---@field CompletionCode integer
---@field NextReading integer
---@field M integer
---@field MT integer
---@field B integer
---@field BA integer
---@field Accuracy integer
---@field RBExp integer
local TGetSensorFactorsRsp = {}
TGetSensorFactorsRsp.__index = TGetSensorFactorsRsp
TGetSensorFactorsRsp.group = {}

local function TGetSensorFactorsRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorFactorsRsp)
end

function TGetSensorFactorsRsp.new(CompletionCode, NextReading, M, MT, B, BA, Accuracy, RBExp)
    return TGetSensorFactorsRsp_from_obj({
        CompletionCode = CompletionCode,
        NextReading = NextReading,
        M = M,
        MT = MT,
        B = B,
        BA = BA,
        Accuracy = Accuracy,
        RBExp = RBExp
    })
end
---@param obj SensorIpmiCmds.GetSensorFactorsRsp
function TGetSensorFactorsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.NextReading = obj.NextReading
    self.M = obj.M
    self.MT = obj.MT
    self.B = obj.B
    self.BA = obj.BA
    self.Accuracy = obj.Accuracy
    self.RBExp = obj.RBExp
end

function TGetSensorFactorsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorFactorsRsp.group)
end

TGetSensorFactorsRsp.from_obj = TGetSensorFactorsRsp_from_obj

TGetSensorFactorsRsp.proto_property = {'CompletionCode', 'NextReading', 'M', 'MT', 'B', 'BA', 'Accuracy', 'RBExp'}

TGetSensorFactorsRsp.default = {0, 0, 0, 0, 0, 0, 0, 0}

TGetSensorFactorsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'NextReading', is_array = false, struct = nil},
    {name = 'M', is_array = false, struct = nil}, {name = 'MT', is_array = false, struct = nil},
    {name = 'B', is_array = false, struct = nil}, {name = 'BA', is_array = false, struct = nil},
    {name = 'Accuracy', is_array = false, struct = nil}, {name = 'RBExp', is_array = false, struct = nil}
}

function TGetSensorFactorsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'NextReading', self.NextReading, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'M', self.M, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MT', self.MT, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'B', self.B, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BA', self.BA, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Accuracy', self.Accuracy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RBExp', self.RBExp, 'uint8', false, errs, need_convert)

    TGetSensorFactorsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorFactorsRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorFactorsRsp:unpack(_)
    return self.CompletionCode, self.NextReading, self.M, self.MT, self.B, self.BA, self.Accuracy, self.RBExp
end

GetSensorFactors.GetSensorFactorsRsp = TGetSensorFactorsRsp

return GetSensorFactors
