--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorEventStatus = {}

---@class SensorIpmiCmds.GetSensorEventStatusReq
---@field Number integer
local TGetSensorEventStatusReq = {}
TGetSensorEventStatusReq.__index = TGetSensorEventStatusReq
TGetSensorEventStatusReq.group = {}

local function TGetSensorEventStatusReq_from_obj(obj)
    return setmetatable(obj, TGetSensorEventStatusReq)
end

function TGetSensorEventStatusReq.new(Number)
    return TGetSensorEventStatusReq_from_obj({Number = Number})
end
---@param obj SensorIpmiCmds.GetSensorEventStatusReq
function TGetSensorEventStatusReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TGetSensorEventStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventStatusReq.group)
end

TGetSensorEventStatusReq.from_obj = TGetSensorEventStatusReq_from_obj

TGetSensorEventStatusReq.proto_property = {'Number'}

TGetSensorEventStatusReq.default = {0}

TGetSensorEventStatusReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TGetSensorEventStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)

    TGetSensorEventStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventStatusReq:unpack(_)
    return self.Number
end

GetSensorEventStatus.GetSensorEventStatusReq = TGetSensorEventStatusReq

---@class SensorIpmiCmds.GetSensorEventStatusRsp
---@field CompletionCode integer
---@field Reserved integer
---@field ReadingUnavailable integer
---@field ScanDisabled integer
---@field AllDisabled integer
---@field AssertStatusL integer
---@field AssertStatusH integer
---@field DeassertStatusL integer
---@field DeassertStatusH integer
local TGetSensorEventStatusRsp = {}
TGetSensorEventStatusRsp.__index = TGetSensorEventStatusRsp
TGetSensorEventStatusRsp.group = {}

local function TGetSensorEventStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorEventStatusRsp)
end

function TGetSensorEventStatusRsp.new(CompletionCode, Reserved, ReadingUnavailable, ScanDisabled, AllDisabled,
    AssertStatusL, AssertStatusH, DeassertStatusL, DeassertStatusH)
    return TGetSensorEventStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        Reserved = Reserved,
        ReadingUnavailable = ReadingUnavailable,
        ScanDisabled = ScanDisabled,
        AllDisabled = AllDisabled,
        AssertStatusL = AssertStatusL,
        AssertStatusH = AssertStatusH,
        DeassertStatusL = DeassertStatusL,
        DeassertStatusH = DeassertStatusH
    })
end
---@param obj SensorIpmiCmds.GetSensorEventStatusRsp
function TGetSensorEventStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Reserved = obj.Reserved
    self.ReadingUnavailable = obj.ReadingUnavailable
    self.ScanDisabled = obj.ScanDisabled
    self.AllDisabled = obj.AllDisabled
    self.AssertStatusL = obj.AssertStatusL
    self.AssertStatusH = obj.AssertStatusH
    self.DeassertStatusL = obj.DeassertStatusL
    self.DeassertStatusH = obj.DeassertStatusH
end

function TGetSensorEventStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventStatusRsp.group)
end

TGetSensorEventStatusRsp.from_obj = TGetSensorEventStatusRsp_from_obj

TGetSensorEventStatusRsp.proto_property = {
    'CompletionCode', 'Reserved', 'ReadingUnavailable', 'ScanDisabled', 'AllDisabled', 'AssertStatusL', 'AssertStatusH',
    'DeassertStatusL', 'DeassertStatusH'
}

TGetSensorEventStatusRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSensorEventStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ReadingUnavailable', is_array = false, struct = nil},
    {name = 'ScanDisabled', is_array = false, struct = nil}, {name = 'AllDisabled', is_array = false, struct = nil},
    {name = 'AssertStatusL', is_array = false, struct = nil}, {name = 'AssertStatusH', is_array = false, struct = nil},
    {name = 'DeassertStatusL', is_array = false, struct = nil},
    {name = 'DeassertStatusH', is_array = false, struct = nil}
}

function TGetSensorEventStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingUnavailable', self.ReadingUnavailable, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ScanDisabled', self.ScanDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AllDisabled', self.AllDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssertStatusL', self.AssertStatusL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssertStatusH', self.AssertStatusH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeassertStatusL', self.DeassertStatusL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeassertStatusH', self.DeassertStatusH, 'uint8', false, errs, need_convert)

    TGetSensorEventStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventStatusRsp:unpack(_)
    return self.CompletionCode, self.Reserved, self.ReadingUnavailable, self.ScanDisabled, self.AllDisabled,
        self.AssertStatusL, self.AssertStatusH, self.DeassertStatusL, self.DeassertStatusH
end

GetSensorEventStatus.GetSensorEventStatusRsp = TGetSensorEventStatusRsp

return GetSensorEventStatus
