--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSelReserveId = {}

---@class SensorIpmiCmds.GetSelReserveIdReq
local TGetSelReserveIdReq = {}
TGetSelReserveIdReq.__index = TGetSelReserveIdReq
TGetSelReserveIdReq.group = {}

local function TGetSelReserveIdReq_from_obj(obj)
    return setmetatable(obj, TGetSelReserveIdReq)
end

function TGetSelReserveIdReq.new()
    return TGetSelReserveIdReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSelReserveIdReq
function TGetSelReserveIdReq:init_from_obj(obj)

end

function TGetSelReserveIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelReserveIdReq.group)
end

TGetSelReserveIdReq.from_obj = TGetSelReserveIdReq_from_obj

TGetSelReserveIdReq.proto_property = {}

TGetSelReserveIdReq.default = {}

TGetSelReserveIdReq.struct = {}

function TGetSelReserveIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSelReserveIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelReserveIdReq.proto_property, errs, need_convert)
    return self
end

function TGetSelReserveIdReq:unpack(_)
end

GetSelReserveId.GetSelReserveIdReq = TGetSelReserveIdReq

---@class SensorIpmiCmds.GetSelReserveIdRsp
---@field CompletionCode integer
---@field ReserveIdL integer
---@field ReserveIdH integer
local TGetSelReserveIdRsp = {}
TGetSelReserveIdRsp.__index = TGetSelReserveIdRsp
TGetSelReserveIdRsp.group = {}

local function TGetSelReserveIdRsp_from_obj(obj)
    return setmetatable(obj, TGetSelReserveIdRsp)
end

function TGetSelReserveIdRsp.new(CompletionCode, ReserveIdL, ReserveIdH)
    return TGetSelReserveIdRsp_from_obj({
        CompletionCode = CompletionCode,
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH
    })
end
---@param obj SensorIpmiCmds.GetSelReserveIdRsp
function TGetSelReserveIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
end

function TGetSelReserveIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelReserveIdRsp.group)
end

TGetSelReserveIdRsp.from_obj = TGetSelReserveIdRsp_from_obj

TGetSelReserveIdRsp.proto_property = {'CompletionCode', 'ReserveIdL', 'ReserveIdH'}

TGetSelReserveIdRsp.default = {0, 0, 0}

TGetSelReserveIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ReserveIdL', is_array = false, struct = nil},
    {name = 'ReserveIdH', is_array = false, struct = nil}
}

function TGetSelReserveIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)

    TGetSelReserveIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelReserveIdRsp.proto_property, errs, need_convert)
    return self
end

function TGetSelReserveIdRsp:unpack(_)
    return self.CompletionCode, self.ReserveIdL, self.ReserveIdH
end

GetSelReserveId.GetSelReserveIdRsp = TGetSelReserveIdRsp

return GetSelReserveId
