--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSelEntry = {}

---@class SensorIpmiCmds.GetSelEntryReq
---@field ReserveIdL integer
---@field ReserveIdH integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Offset integer
---@field Count integer
local TGetSelEntryReq = {}
TGetSelEntryReq.__index = TGetSelEntryReq
TGetSelEntryReq.group = {}

local function TGetSelEntryReq_from_obj(obj)
    return setmetatable(obj, TGetSelEntryReq)
end

function TGetSelEntryReq.new(ReserveIdL, ReserveIdH, RecordIdL, RecordIdH, Offset, Count)
    return TGetSelEntryReq_from_obj({
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Offset = Offset,
        Count = Count
    })
end
---@param obj SensorIpmiCmds.GetSelEntryReq
function TGetSelEntryReq:init_from_obj(obj)
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Offset = obj.Offset
    self.Count = obj.Count
end

function TGetSelEntryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelEntryReq.group)
end

TGetSelEntryReq.from_obj = TGetSelEntryReq_from_obj

TGetSelEntryReq.proto_property = {'ReserveIdL', 'ReserveIdH', 'RecordIdL', 'RecordIdH', 'Offset', 'Count'}

TGetSelEntryReq.default = {0, 0, 0, 0, 0, 0}

TGetSelEntryReq.struct = {
    {name = 'ReserveIdL', is_array = false, struct = nil}, {name = 'ReserveIdH', is_array = false, struct = nil},
    {name = 'RecordIdL', is_array = false, struct = nil}, {name = 'RecordIdH', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TGetSelEntryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TGetSelEntryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelEntryReq.proto_property, errs, need_convert)
    return self
end

function TGetSelEntryReq:unpack(_)
    return self.ReserveIdL, self.ReserveIdH, self.RecordIdL, self.RecordIdH, self.Offset, self.Count
end

GetSelEntry.GetSelEntryReq = TGetSelEntryReq

---@class SensorIpmiCmds.GetSelEntryRsp
---@field CompletionCode integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Datas string
local TGetSelEntryRsp = {}
TGetSelEntryRsp.__index = TGetSelEntryRsp
TGetSelEntryRsp.group = {}

local function TGetSelEntryRsp_from_obj(obj)
    return setmetatable(obj, TGetSelEntryRsp)
end

function TGetSelEntryRsp.new(CompletionCode, RecordIdL, RecordIdH, Datas)
    return TGetSelEntryRsp_from_obj({
        CompletionCode = CompletionCode,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.GetSelEntryRsp
function TGetSelEntryRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Datas = obj.Datas
end

function TGetSelEntryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelEntryRsp.group)
end

TGetSelEntryRsp.from_obj = TGetSelEntryRsp_from_obj

TGetSelEntryRsp.proto_property = {'CompletionCode', 'RecordIdL', 'RecordIdH', 'Datas'}

TGetSelEntryRsp.default = {0, 0, 0, ''}

TGetSelEntryRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordIdL', is_array = false, struct = nil},
    {name = 'RecordIdH', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TGetSelEntryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TGetSelEntryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelEntryRsp.proto_property, errs, need_convert)
    return self
end

function TGetSelEntryRsp:unpack(_)
    return self.CompletionCode, self.RecordIdL, self.RecordIdH, self.Datas
end

GetSelEntry.GetSelEntryRsp = TGetSelEntryRsp

return GetSelEntry
