--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSelAllocInfo = {}

---@class SensorIpmiCmds.GetSelAllocInfoReq
local TGetSelAllocInfoReq = {}
TGetSelAllocInfoReq.__index = TGetSelAllocInfoReq
TGetSelAllocInfoReq.group = {}

local function TGetSelAllocInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSelAllocInfoReq)
end

function TGetSelAllocInfoReq.new()
    return TGetSelAllocInfoReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSelAllocInfoReq
function TGetSelAllocInfoReq:init_from_obj(obj)

end

function TGetSelAllocInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelAllocInfoReq.group)
end

TGetSelAllocInfoReq.from_obj = TGetSelAllocInfoReq_from_obj

TGetSelAllocInfoReq.proto_property = {}

TGetSelAllocInfoReq.default = {}

TGetSelAllocInfoReq.struct = {}

function TGetSelAllocInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSelAllocInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelAllocInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSelAllocInfoReq:unpack(_)
end

GetSelAllocInfo.GetSelAllocInfoReq = TGetSelAllocInfoReq

---@class SensorIpmiCmds.GetSelAllocInfoRsp
---@field CompletionCode integer
---@field UnitL integer
---@field UnitH integer
---@field SizeL integer
---@field SizeH integer
---@field FreeL integer
---@field FreeH integer
---@field BlockL integer
---@field BlockH integer
---@field MaxSize integer
local TGetSelAllocInfoRsp = {}
TGetSelAllocInfoRsp.__index = TGetSelAllocInfoRsp
TGetSelAllocInfoRsp.group = {}

local function TGetSelAllocInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSelAllocInfoRsp)
end

function TGetSelAllocInfoRsp.new(CompletionCode, UnitL, UnitH, SizeL, SizeH, FreeL, FreeH, BlockL, BlockH, MaxSize)
    return TGetSelAllocInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        UnitL = UnitL,
        UnitH = UnitH,
        SizeL = SizeL,
        SizeH = SizeH,
        FreeL = FreeL,
        FreeH = FreeH,
        BlockL = BlockL,
        BlockH = BlockH,
        MaxSize = MaxSize
    })
end
---@param obj SensorIpmiCmds.GetSelAllocInfoRsp
function TGetSelAllocInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.UnitL = obj.UnitL
    self.UnitH = obj.UnitH
    self.SizeL = obj.SizeL
    self.SizeH = obj.SizeH
    self.FreeL = obj.FreeL
    self.FreeH = obj.FreeH
    self.BlockL = obj.BlockL
    self.BlockH = obj.BlockH
    self.MaxSize = obj.MaxSize
end

function TGetSelAllocInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelAllocInfoRsp.group)
end

TGetSelAllocInfoRsp.from_obj = TGetSelAllocInfoRsp_from_obj

TGetSelAllocInfoRsp.proto_property = {
    'CompletionCode', 'UnitL', 'UnitH', 'SizeL', 'SizeH', 'FreeL', 'FreeH', 'BlockL', 'BlockH', 'MaxSize'
}

TGetSelAllocInfoRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSelAllocInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'UnitL', is_array = false, struct = nil},
    {name = 'UnitH', is_array = false, struct = nil}, {name = 'SizeL', is_array = false, struct = nil},
    {name = 'SizeH', is_array = false, struct = nil}, {name = 'FreeL', is_array = false, struct = nil},
    {name = 'FreeH', is_array = false, struct = nil}, {name = 'BlockL', is_array = false, struct = nil},
    {name = 'BlockH', is_array = false, struct = nil}, {name = 'MaxSize', is_array = false, struct = nil}
}

function TGetSelAllocInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitL', self.UnitL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitH', self.UnitH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SizeL', self.SizeL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SizeH', self.SizeH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeL', self.FreeL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeH', self.FreeH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockL', self.BlockL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockH', self.BlockH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MaxSize', self.MaxSize, 'uint8', false, errs, need_convert)

    TGetSelAllocInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelAllocInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSelAllocInfoRsp:unpack(_)
    return self.CompletionCode, self.UnitL, self.UnitH, self.SizeL, self.SizeH, self.FreeL, self.FreeH, self.BlockL,
        self.BlockH, self.MaxSize
end

GetSelAllocInfo.GetSelAllocInfoRsp = TGetSelAllocInfoRsp

return GetSelAllocInfo
