--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPEFLastEventId = {}

---@class SensorIpmiCmds.GetPEFLastEventIdReq
local TGetPEFLastEventIdReq = {}
TGetPEFLastEventIdReq.__index = TGetPEFLastEventIdReq
TGetPEFLastEventIdReq.group = {}

local function TGetPEFLastEventIdReq_from_obj(obj)
    return setmetatable(obj, TGetPEFLastEventIdReq)
end

function TGetPEFLastEventIdReq.new()
    return TGetPEFLastEventIdReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetPEFLastEventIdReq
function TGetPEFLastEventIdReq:init_from_obj(obj)

end

function TGetPEFLastEventIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFLastEventIdReq.group)
end

TGetPEFLastEventIdReq.from_obj = TGetPEFLastEventIdReq_from_obj

TGetPEFLastEventIdReq.proto_property = {}

TGetPEFLastEventIdReq.default = {}

TGetPEFLastEventIdReq.struct = {}

function TGetPEFLastEventIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPEFLastEventIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFLastEventIdReq.proto_property, errs, need_convert)
    return self
end

function TGetPEFLastEventIdReq:unpack(_)
end

GetPEFLastEventId.GetPEFLastEventIdReq = TGetPEFLastEventIdReq

---@class SensorIpmiCmds.GetPEFLastEventIdRsp
---@field CompletionCode integer
---@field Timestamp integer
---@field SELId integer
---@field SMSId integer
---@field BMCId integer
local TGetPEFLastEventIdRsp = {}
TGetPEFLastEventIdRsp.__index = TGetPEFLastEventIdRsp
TGetPEFLastEventIdRsp.group = {}

local function TGetPEFLastEventIdRsp_from_obj(obj)
    return setmetatable(obj, TGetPEFLastEventIdRsp)
end

function TGetPEFLastEventIdRsp.new(CompletionCode, Timestamp, SELId, SMSId, BMCId)
    return TGetPEFLastEventIdRsp_from_obj({
        CompletionCode = CompletionCode,
        Timestamp = Timestamp,
        SELId = SELId,
        SMSId = SMSId,
        BMCId = BMCId
    })
end
---@param obj SensorIpmiCmds.GetPEFLastEventIdRsp
function TGetPEFLastEventIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Timestamp = obj.Timestamp
    self.SELId = obj.SELId
    self.SMSId = obj.SMSId
    self.BMCId = obj.BMCId
end

function TGetPEFLastEventIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFLastEventIdRsp.group)
end

TGetPEFLastEventIdRsp.from_obj = TGetPEFLastEventIdRsp_from_obj

TGetPEFLastEventIdRsp.proto_property = {'CompletionCode', 'Timestamp', 'SELId', 'SMSId', 'BMCId'}

TGetPEFLastEventIdRsp.default = {0, 0, 0, 0, 0}

TGetPEFLastEventIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Timestamp', is_array = false, struct = nil},
    {name = 'SELId', is_array = false, struct = nil}, {name = 'SMSId', is_array = false, struct = nil},
    {name = 'BMCId', is_array = false, struct = nil}
}

function TGetPEFLastEventIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timestamp', self.Timestamp, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'SELId', self.SELId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SMSId', self.SMSId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'BMCId', self.BMCId, 'uint16', false, errs, need_convert)

    TGetPEFLastEventIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFLastEventIdRsp.proto_property, errs, need_convert)
    return self
end

function TGetPEFLastEventIdRsp:unpack(_)
    return self.CompletionCode, self.Timestamp, self.SELId, self.SMSId, self.BMCId
end

GetPEFLastEventId.GetPEFLastEventIdRsp = TGetPEFLastEventIdRsp

return GetPEFLastEventId
