--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceSDRInfo = {}

---@class SensorIpmiCmds.GetDeviceSDRInfoReq
---@field Datas string
local TGetDeviceSDRInfoReq = {}
TGetDeviceSDRInfoReq.__index = TGetDeviceSDRInfoReq
TGetDeviceSDRInfoReq.group = {}

local function TGetDeviceSDRInfoReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceSDRInfoReq)
end

function TGetDeviceSDRInfoReq.new(Datas)
    return TGetDeviceSDRInfoReq_from_obj({Datas = Datas})
end
---@param obj SensorIpmiCmds.GetDeviceSDRInfoReq
function TGetDeviceSDRInfoReq:init_from_obj(obj)
    self.Datas = obj.Datas
end

function TGetDeviceSDRInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSDRInfoReq.group)
end

TGetDeviceSDRInfoReq.from_obj = TGetDeviceSDRInfoReq_from_obj

TGetDeviceSDRInfoReq.proto_property = {'Datas'}

TGetDeviceSDRInfoReq.default = {''}

TGetDeviceSDRInfoReq.struct = {{name = 'Datas', is_array = false, struct = nil}}

function TGetDeviceSDRInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TGetDeviceSDRInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSDRInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSDRInfoReq:unpack(_)
    return self.Datas
end

GetDeviceSDRInfo.GetDeviceSDRInfoReq = TGetDeviceSDRInfoReq

---@class SensorIpmiCmds.GetDeviceSDRInfoRsp
---@field CompletionCode integer
---@field Count integer
---@field DynamicSensor integer
---@field Reserved integer
---@field Lun integer
---@field Population integer
local TGetDeviceSDRInfoRsp = {}
TGetDeviceSDRInfoRsp.__index = TGetDeviceSDRInfoRsp
TGetDeviceSDRInfoRsp.group = {}

local function TGetDeviceSDRInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceSDRInfoRsp)
end

function TGetDeviceSDRInfoRsp.new(CompletionCode, Count, DynamicSensor, Reserved, Lun, Population)
    return TGetDeviceSDRInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        Count = Count,
        DynamicSensor = DynamicSensor,
        Reserved = Reserved,
        Lun = Lun,
        Population = Population
    })
end
---@param obj SensorIpmiCmds.GetDeviceSDRInfoRsp
function TGetDeviceSDRInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Count = obj.Count
    self.DynamicSensor = obj.DynamicSensor
    self.Reserved = obj.Reserved
    self.Lun = obj.Lun
    self.Population = obj.Population
end

function TGetDeviceSDRInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSDRInfoRsp.group)
end

TGetDeviceSDRInfoRsp.from_obj = TGetDeviceSDRInfoRsp_from_obj

TGetDeviceSDRInfoRsp.proto_property = {'CompletionCode', 'Count', 'DynamicSensor', 'Reserved', 'Lun', 'Population'}

TGetDeviceSDRInfoRsp.default = {0, 0, 0, 0, 0, 0}

TGetDeviceSDRInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil},
    {name = 'DynamicSensor', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Lun', is_array = false, struct = nil}, {name = 'Population', is_array = false, struct = nil}
}

function TGetDeviceSDRInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DynamicSensor', self.DynamicSensor, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Lun', self.Lun, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Population', self.Population, 'uint32', false, errs, need_convert)

    TGetDeviceSDRInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSDRInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSDRInfoRsp:unpack(_)
    return self.CompletionCode, self.Count, self.DynamicSensor, self.Reserved, self.Lun, self.Population
end

GetDeviceSDRInfo.GetDeviceSDRInfoRsp = TGetDeviceSDRInfoRsp

return GetDeviceSDRInfo
