--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local AddSDR = {}

---@class SensorIpmiCmds.AddSDRReq
---@field Datas string
local TAddSDRReq = {}
TAddSDRReq.__index = TAddSDRReq
TAddSDRReq.group = {}

local function TAddSDRReq_from_obj(obj)
    return setmetatable(obj, TAddSDRReq)
end

function TAddSDRReq.new(Datas)
    return TAddSDRReq_from_obj({Datas = Datas})
end
---@param obj SensorIpmiCmds.AddSDRReq
function TAddSDRReq:init_from_obj(obj)
    self.Datas = obj.Datas
end

function TAddSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddSDRReq.group)
end

TAddSDRReq.from_obj = TAddSDRReq_from_obj

TAddSDRReq.proto_property = {'Datas'}

TAddSDRReq.default = {''}

TAddSDRReq.struct = {{name = 'Datas', is_array = false, struct = nil}}

function TAddSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TAddSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddSDRReq.proto_property, errs, need_convert)
    return self
end

function TAddSDRReq:unpack(_)
    return self.Datas
end

AddSDR.AddSDRReq = TAddSDRReq

---@class SensorIpmiCmds.AddSDRRsp
---@field CompletionCode integer
---@field RecordIdL integer
---@field RecordIdH integer
local TAddSDRRsp = {}
TAddSDRRsp.__index = TAddSDRRsp
TAddSDRRsp.group = {}

local function TAddSDRRsp_from_obj(obj)
    return setmetatable(obj, TAddSDRRsp)
end

function TAddSDRRsp.new(CompletionCode, RecordIdL, RecordIdH)
    return TAddSDRRsp_from_obj({CompletionCode = CompletionCode, RecordIdL = RecordIdL, RecordIdH = RecordIdH})
end
---@param obj SensorIpmiCmds.AddSDRRsp
function TAddSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
end

function TAddSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddSDRRsp.group)
end

TAddSDRRsp.from_obj = TAddSDRRsp_from_obj

TAddSDRRsp.proto_property = {'CompletionCode', 'RecordIdL', 'RecordIdH'}

TAddSDRRsp.default = {0, 0, 0}

TAddSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordIdL', is_array = false, struct = nil},
    {name = 'RecordIdH', is_array = false, struct = nil}
}

function TAddSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)

    TAddSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddSDRRsp.proto_property, errs, need_convert)
    return self
end

function TAddSDRRsp:unpack(_)
    return self.CompletionCode, self.RecordIdL, self.RecordIdH
end

AddSDR.AddSDRRsp = TAddSDRRsp

return AddSDR
