-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiPefAlertFilter = {}

---@class MIpmiPefAlertFilter.AlertString
---@field AlertString integer
local TAlertString = {}
TAlertString.__index = TAlertString
TAlertString.group = {}

local function TAlertString_from_obj(obj)
    return setmetatable(obj, TAlertString)
end

function TAlertString.new(AlertString)
    return TAlertString_from_obj({AlertString = AlertString})
end
---@param obj MIpmiPefAlertFilter.AlertString
function TAlertString:init_from_obj(obj)
    self.AlertString = obj.AlertString
end

function TAlertString:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlertString.group)
end

TAlertString.from_obj = TAlertString_from_obj

TAlertString.proto_property = {'AlertString'}

TAlertString.default = {0}

TAlertString.struct = {{name = 'AlertString', is_array = false, struct = nil}}

function TAlertString:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlertString', self.AlertString, 'uint8', false, errs, need_convert)

    TAlertString:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlertString.proto_property, errs, need_convert)
    return self
end

function TAlertString:unpack(_)
    return self.AlertString
end

MIpmiPefAlertFilter.AlertString = TAlertString

---@class MIpmiPefAlertFilter.Destination
---@field Destination integer
local TDestination = {}
TDestination.__index = TDestination
TDestination.group = {}

local function TDestination_from_obj(obj)
    return setmetatable(obj, TDestination)
end

function TDestination.new(Destination)
    return TDestination_from_obj({Destination = Destination})
end
---@param obj MIpmiPefAlertFilter.Destination
function TDestination:init_from_obj(obj)
    self.Destination = obj.Destination
end

function TDestination:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestination.group)
end

TDestination.from_obj = TDestination_from_obj

TDestination.proto_property = {'Destination'}

TDestination.default = {0}

TDestination.struct = {{name = 'Destination', is_array = false, struct = nil}}

function TDestination:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Destination', self.Destination, 'uint8', false, errs, need_convert)

    TDestination:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestination.proto_property, errs, need_convert)
    return self
end

function TDestination:unpack(_)
    return self.Destination
end

MIpmiPefAlertFilter.Destination = TDestination

---@class MIpmiPefAlertFilter.PolicyNum
---@field PolicyNum integer
local TPolicyNum = {}
TPolicyNum.__index = TPolicyNum
TPolicyNum.group = {}

local function TPolicyNum_from_obj(obj)
    return setmetatable(obj, TPolicyNum)
end

function TPolicyNum.new(PolicyNum)
    return TPolicyNum_from_obj({PolicyNum = PolicyNum})
end
---@param obj MIpmiPefAlertFilter.PolicyNum
function TPolicyNum:init_from_obj(obj)
    self.PolicyNum = obj.PolicyNum
end

function TPolicyNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyNum.group)
end

TPolicyNum.from_obj = TPolicyNum_from_obj

TPolicyNum.proto_property = {'PolicyNum'}

TPolicyNum.default = {0}

TPolicyNum.struct = {{name = 'PolicyNum', is_array = false, struct = nil}}

function TPolicyNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PolicyNum', self.PolicyNum, 'uint8', false, errs, need_convert)

    TPolicyNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyNum.proto_property, errs, need_convert)
    return self
end

function TPolicyNum:unpack(_)
    return self.PolicyNum
end

MIpmiPefAlertFilter.PolicyNum = TPolicyNum

return MIpmiPefAlertFilter
