# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
import shutil
from conanbase import ConanBase, copy, os

required_conan_version = ">=1.60.0"


class AppConan(ConanBase):

    def build(self):
        # 修改工作目录
        scripts_path = "dist/user_conf/rootfs/opt/bmc/"
        os.chdir(os.path.join(self.source_folder, scripts_path))
        if self.options.chipv2_enable:
            shutil.copyfile("../../v2/rc.sysinit", "../../etc/rc.d/rc.sysinit")
            shutil.copyfile("../../v2/log_partition_check.sh", "script/log_partition_check.sh")
        else:
            shutil.copyfile("../../v1/rc.sysinit", "../../etc/rc.d/rc.sysinit")
            shutil.copyfile("../../v1/log_partition_check.sh", "script/log_partition_check.sh")

        if self.settings.build_type == "Release":
            self.run("sed -i '$ i\chown root:root /dev/shm/dbus/.dbus' rundbus.sh")
            self.run("sed -i '$ i\chmod 400 /dev/shm/dbus/.dbus' rundbus.sh")
        else:
            self.run("sed -i '$ i\chmod 444 /dev/shm/dbus/.dbus' rundbus.sh")
        self.run("sed -i '$ i\sleep 1' rundbus.sh")

        if self.settings.build_type == "Release":
            os.chdir("../../etc/rc.d")
            self.run("sed -i '/suid_dumpable/d' rc.sysinit")

    def package(self):
        super().package()
        copy(self, "permissions.ini", src=os.path.join(self.source_folder, "dist"), dst=self.package_folder)

    def package_info(self):
        pass
