# rootfs_user

## 1. 功能简介
用户根文件系统（root file system），负责提供iBMC的启动（基于RTOS）运行的基本环境，包括分区挂载，设备驱动程序载入，以及数据等

## 2. 关键特性
配置仓，用于存放iBMC各类配置文件和启动阶段运行的配置脚本

## 3. 对外接口
NA

## 4. 配置介绍
```
user_conf/
└── rootfs
    ├── data
    │   ├── backup
    │   └── trust
    ├── etc
    │   ├── ld.so.preload               （利用动态库的preload机制，对libc的fopen（带有w/w+/a/a+参数），fwrite，truncate，ftruncate，fprintf，vfpintf增加hook函数，如果写保护已开启，并且文件路径不在白名单下，则拦截写入）
    │   ├── logrotate.conf              （日志转储工具logrotate配置文件）
    │   ├── pam.d
    │   │   └── sshd                    （sshd服务配置文件）
    │   ├── prerotate.sh                （循环检查传入的参数的文件大小是否超过100MB。若存在超过100MB的文件，记录维护日志）
    │   ├── rc.d                        （存放BMC启动时加载的初始化脚本，能够加载驱动以及BMC自定义脚本等）
    │   │   ├── rc.start                （支持组件定制启动项，rc.start目录下脚本在系统初始化时运行）
    │   │   │   └── ensure_exist.sh
    │   │   └── rc.sysinit              （脚本文件，在系统启动过程中的最后阶段被执行，该文件负责分区挂载，设备驱动程序载入，关键目录文件的创建）
    │   ├── rsyslog.conf                （日志服务配置，定义了服务的名称、日志等级和日志记录位置）
    │   ├── rsyslog_restricted.conf     （日志写保护服务配置文件）
    │   ├── sysconfig
    │   │   └── rsyslog
    │   ├── sysctl.conf                 （sysctl配置，用于在运行时配置内核参数）
    │   └── systemd
    │       ├── journald.conf
    │       └── system
    │           ├── logrotate.service
    │           ├── logrotate.timer
    │           ├── multi-user.target.wants
    │           │   ├── logrotate.service -> ../logrotate.service
    │           │   ├── logrotate.timer -> ../logrotate.timer
    │           │   └── rsyslog.service -> ../rsyslog.service
    │           ├── rsyslog.service                 （日志服务）
    │           └── rsyslog_restricted.service      （日志写保护服务）
    └── opt
        └── bmc
            ├── conf
            │   └── graft
            ├── pram
            ├── pram0
            ├── rundbus.sh                  （启动dbus）
            ├── script
            │   ├── allocate_harbor_id.sh   （分配harbor id，帮助提供节点间通信服务）
            │   ├── insmod_driver.sh        （模块驱动加载）
            │   ├── log_partition_check.sh
            │   ├── partition_migrate.sh    （检查设备的分区表是V3分区表还是V2分区表）
            │   └── trust_partition_check.sh
            ├── trust
            │   └── mini_system.json
            └── web
                └── htdocs
                    └── error_page          （网页错误码提示信息）
                        ├── 404.html
                        ├── 40x.html
                        ├── 50x.html
                        ├── uploadfile_error.json
                        ├── uploadfile_insufficient_space.json
                        ├── uploadfile_unauth.json
                        └── url_notfound.json
```