-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m_mapper = require 'route_mapper.route_mapper'
local run = require 'run'
local utils_core = require 'utils.core'
local m_tree = require 'tree'

local project_dir = os.getenv('PROJECT_DIR')
local build_dir = os.getenv('ROOT_DIR')

TestRedfish = {}

function TestRedfish:load(path, tree, mapper)
    if not utils_core.is_dir(path) then
        self:load_one(path, tree, mapper)
        return
    end

    for _, file_name in pairs(utils_core.dir(path)) do
        self:load(path .. '/' .. file_name, tree, mapper)
    end
end

function TestRedfish:load_one(path, tree, mapper)
    print('========== ' .. path .. ' ==========')
    local m = run.new(tree, mapper)
    local ok = m:parse(path)
    if not ok then
        print(path .. " DT failed!")
        return
    end

    ok = m:run()
    if not ok then
        print(path .. " DT failed!")
        return
    end

    print(path .. " DT successfully!")
end

function TestRedfish:test()
    print('========== redfish DT start! ==========')
    local tree = m_tree.new()
    local mapper = m_mapper.new(build_dir .. '/opt/bmc/apps/redfish/interface_config/mapping_config', {})
    self:load(project_dir .. '/test/unit/cases/redfish', tree, mapper)
    print('========== redfish DT end! ==========')
end
