-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local res = {}

for i = 1, 9 do
    local fw = {}
    fw['MeasuredObject'] = ProcessingFlow[i].Destination.Name
    fw['PCR'] = ProcessingFlow[i].Destination.PCRName
    fw['ActualDigest'] = ProcessingFlow[i].Destination.ActualDigest
    fw['StandardDigest'] = ProcessingFlow[i].Destination.StandardDigest
    fw['IsMatch'] = ProcessingFlow[i].Destination.ComparedResult == 0
    fw['Version'] = ProcessingFlow[i].Destination.Version

    res[i] = fw
end

-- Coprocessor固件信息
local CopNotSupported<const> = 2
local Cop1FlowIdx<const> = 14
local Cop1FlowVersionIdx<const> = 15
local Cop1ResIdx<const> = 10

local cop1_compare_result = ProcessingFlow[Cop1FlowIdx].Destination.ComparedResult

if cop1_compare_result ~= nil and cop1_compare_result ~= CopNotSupported then
    local cop1 = {}
    cop1['MeasuredObject'] = ProcessingFlow[Cop1FlowIdx].Destination.Name
    cop1['PCR'] = ProcessingFlow[Cop1FlowIdx].Destination.PCRName
    cop1['ActualDigest'] = ProcessingFlow[Cop1FlowIdx].Destination.ActualDigest
    cop1['StandardDigest'] = ProcessingFlow[Cop1FlowIdx].Destination.StandardDigest
    cop1['IsMatch'] = ProcessingFlow[Cop1FlowIdx].Destination.ComparedResult == 0
    -- 版本号Version从平台处获取
    cop1['Version'] = ProcessingFlow[Cop1FlowVersionIdx].Destination.Version
    res[Cop1ResIdx] = cop1
end

-- 针对 M3 部分固件的 Version 需要从其它地方获取
-- L1
res[1]['Version'] = ProcessingFlow[10].Destination.Version
-- UBOOT
res[2]['Version'] = string.format("%s(%s)", ProcessingFlow[11].Destination.Version,
    ProcessingFlow[11].Destination.ReleaseDate)
-- Rootfs

-- BIOS
res[4]['Version'] = string.format("%s(%s)", ProcessingFlow[12].Destination.Version,
    ProcessingFlow[12].Destination.Location)

return res