-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local old_groups = ProcessingFlow[3].Destination.Groups
local new_groups = {
    "/bmc/kepler/AccountService/RemoteGroupDefault/1",
    "/bmc/kepler/AccountService/RemoteGroupDefault/2",
    "/bmc/kepler/AccountService/RemoteGroupDefault/3",
    "/bmc/kepler/AccountService/RemoteGroupDefault/4",
    "/bmc/kepler/AccountService/RemoteGroupDefault/5"
}
for _, group in ipairs(old_groups) do
    -- 示例: 从/bmc/kepler/AccountService/RemoteGroups/LDAP1_2中获取LDAP后的1
    local controller_id, group_id = string.match(group, '.*/LDAP(%d+)_(%d+)')
    if controller_id == Uri.controllerid then
        new_groups[tonumber(group_id)] = group
    end
end
return new_groups