-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local cjson = require 'cjson'
local BIOS_MDB_INTF <const> = "bmc.kepler.UpdateService.FirmwareInfo"
local BIOS_MDB_PATH <const> = "/bmc/kepler/UpdateService/FirmwareInventory/Bios"
local m = {}

function m.encode_attributes(attributes)
    local data = cjson.json_object_new_object()
    data['Attributes'] = attributes
    return attributes ~= nil and cjson.json_object_ordered_encode(data) or nil
end

function m.get_bios_objects(system_ids)
    local bios_objects = {}
    local cnt = 0
    for _, id in pairs(system_ids) do
        local path = BIOS_MDB_PATH
        if tonumber(id) ~= 1 then
            path = path .. id
        end
        local obj = mdb.get_object(bus, path, BIOS_MDB_INTF)

        local bios_object = {}
        bios_object['SystemId'] = tonumber(id)
        bios_object['Version'] = obj.Version
        if obj.ReleaseDate == "" then
            bios_object['ReleaseDate'] = cjson.null
        else
            bios_object['ReleaseDate'] = obj.ReleaseDate
        end

        table.insert(bios_objects, bios_object)
        cnt = cnt + 1
    end
    if cnt == 1 then
        return cjson.null
    end
    return bios_objects
end

return m
