-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ocp_card_list = {}
local ocp_cards = Input

for _, value in pairs(ocp_cards) do
    ocp_card_list[#ocp_card_list + 1] = {
        oCPCardIndex = value.oCPCardIndex,
        oCPCardPresence = value.oCPCardPresence,
        oCPCardStatus = value.oCPCardStatus + 1,
        oCPCardAvailability = value.oCPCardAvailability,
        oCPCardLocation = value.oCPCardLocation,
        oCPCardFunction = "PCIe device",
        oCPCardName = value.oCPCardName,
        oCPCardVID = value.oCPCardVID,
        oCPCardDID = value.oCPCardDID,
        oCPCardManufacturer = value.oCPCardManufacturer,
        oCPCardDescription = value.oCPCardDescription
    }
end
return ocp_card_list