-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local fan_entire_status = 0
local fans = Input

for _, value in pairs(fans) do
    local isTwins = value.IsTwins

    if value.RearStatus + 1 > fan_entire_status then
        fan_entire_status = value.RearStatus + 1
    end

    if isTwins and value.FrontStatus + 1 > fan_entire_status then
        fan_entire_status = value.FrontStatus + 1
    end
end

if fan_entire_status == 0 then
    -- entire_status值未知记为unknown(6)
    return 6
end
return fan_entire_status