-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local info = cjson.decode(Input)
local physical_address, stack_pcId, row_column, bank, error_count, time = {}, {}, {}, {}, {}, {}
for i, v in ipairs(info) do
    physical_address[i] = v.PhysicalAddress
    stack_pcId[i] = v.StackPcId
    row_column[i] = v.RowColumn
    bank[i] = v.Bank
    error_count[i] = v.ErrorCount
    time[i] = v.Time
end
info.PhysicalAddress = table.concat(physical_address, ', ') or ''
info.StackPcId = table.concat(stack_pcId, ', ') or ''
info.RowColumn = table.concat(row_column, ', ') or ''
info.Bank = table.concat(bank, ', ') or ''
info.ErrorCount = table.concat(error_count, ', ') or ''
info.Time = table.concat(time, ', ') or ''
return info
