-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local mdb_service = require 'mc.mdb.mdb_service'

local M = {}

local PATH_SECURITY_MODULE_SYSTEM<const> = "/bmc/kepler/Systems/1/SecurityModule"
local INFT_SECURITY_MODULE<const> = 'bmc.kepler.Systems.SecurityModule'

local function is_valid_path(path)
    local ok, rsp = pcall(mdb_service.is_valid_path, bus, path)
    if not ok then
        log:error('Invalid Path, err(%s)', rsp.message)
        error(rsp)
    end
    return rsp.Result
end

local function is_tpm_exist()
    -- 判断是否存在安全系统资源
    local is_manager_exist = is_valid_path(PATH_SECURITY_MODULE_SYSTEM)
    if not is_manager_exist then
        return false, {}
    end
    -- 获取TPM资源树对象
    local tpm_mdb_list = mdb_service.get_sub_paths(bus, PATH_SECURITY_MODULE_SYSTEM, 1, {INFT_SECURITY_MODULE}).SubPaths
    if #tpm_mdb_list == 0 then
        return false, {}
    end
    return true, mdb.get_object(bus, tpm_mdb_list[1], INFT_SECURITY_MODULE)
end

function M.get_presense()
    local is_exist, mdb_object = is_tpm_exist()
    if not is_exist then
        return 1
    end
    return mdb_object.Presence + 1
end

function M.get_specification_type()
    local is_exist, mdb_object = is_tpm_exist()
    if not is_exist then
        return 'N/A'
    end
    return mdb_object.Protocol
end

function M.get_specification_version()
    local is_exist, mdb_object = is_tpm_exist()
    if not is_exist then
        return 'N/A'
    end
    return mdb_object.ProtocolVersion
end

function M.get_manufacturer_name()
    local is_exist, mdb_object = is_tpm_exist()
    if not is_exist then
        return 'N/A'
    end
    return mdb_object.Manufacturer
end

function M.get_manufacturer_version()
    local is_exist, mdb_object = is_tpm_exist()
    if not is_exist then
        return 'N/A'
    end
    return mdb_object.FirmwareVersion
end

return M
