-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local mdb_service = require 'mc.mdb.mdb_service'
local utils_core = require 'utils.core'
local log = require 'mc.logging'
local PATTERN_PATH_LED = '^/bmc/kepler/Systems/.*/Leds/Led_UIDLed_.*'
local PATH_LEDS = '/bmc/kepler/Systems/1/Leds'
local INFT_LED = 'bmc.kepler.Systems.Led'

local detection_path = '/bmc/kepler/Chassis/1/ThermalSubsystem/LeakDetection'
local detection_interface = 'bmc.kepler.Chassis.LeakDetection'
local LEAK_STRATEGY_INVALID_VALUE<const> = -1

local M = {}

function M.get_uid_led_path()
    local led_paths = mdb_service.get_sub_paths(bus, PATH_LEDS, 1, {INFT_LED}).SubPaths
    for _, path in pairs(led_paths) do
        if utils_core.g_regex_match(PATTERN_PATH_LED, path) then
            return path
        end
    end
    return ""
end

-- 是否支持漏液检测
function M.get_leakdetect_support()
    -- 确认资源树对象
    local ok, obj = pcall(mdb.get_object, bus, detection_path, detection_interface)
    if not ok then
        log:error('Get leak detection obj failed, err_msg: %s', obj)
        error(custom_messages.PropertyModificationNotSupported())
    end

    -- 确认是否支持漏液下电设置动作
    if obj.Enabled ~= true then
        log:error("Don't support leakage detection")
        error(custom_messages.PropertyModificationNotSupported())
    end
    return true
end

function M.get_leak_power_policy(enabled, policy)
    if enabled ~= true then
        return LEAK_STRATEGY_INVALID_VALUE
    end
    return policy + 1
end

return M
