-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local path = ProcessingFlow[4].Destination.Path
local id = string.match(path, '/bmc/kepler/UpdateService/FirmwareInventory/(.*)')

local item_list = cjson.json_object_new_array() -- cjson有序接口，生成的JSON对象数据保持与添加的顺序一致
local item = cjson.json_object_new_object()

if id == "ActiveUboot" or id == "BackupUboot" then
    return item_list
end

if string.match(id, "LinkBoard") then
    item['@odata.id'] = '/redfish/v1/Oem/{{OemIdentifier}}/LCNService/LCNDevices/LinkBoard' .. string.match(id, "%d+")
    item_list[1] = item
    return item_list
end

local const_map = {}
const_map['Bios'] = '/redfish/v1/Systems/1/Bios'
if const_map[id] then
    item['@odata.id'] = const_map[id]
    item_list[1] = item
    return item_list
end

local map = {}
map['BCU'] = 'CpuBoard'
map['EXU'] = 'ExpBoard'
map['SEU'] = 'DiskBP'
local id_table = {}
for w in string.gmatch(id, '[^_]+') do
    table.insert(id_table, w)
end

if string.match(id, 'CPLD') or string.match(id, 'MCU') or string.match(id, 'SR') or
  string.match(id, 'VRD') or string.match(id, 'Retimer') then
    for _, board in ipairs(Input) do
        -- 天工AI机型无挂耳,chassisBMC对象配置在扩展板上,需要单独判断chassisBMC
        if board.NodeId == 'chassisBMC' then
            -- PSR仅有SR需要升级,无其它固件
            if string.match(id, 'PSR') ~= nil then
                item['@odata.id'] = '/redfish/v1/Chassis/1/Boards/' .. board.NodeId
                item_list[1] = item
                return item_list
            end
        elseif board.Id == id_table[#id_table] and type(board.NodeId) == 'string' then
            if board.Type == 'PCIeCard' then
                item['@odata.id'] = '/redfish/v1/Chassis/1/PCIeDevices/' .. board.NodeId
            else
                item['@odata.id'] = '/redfish/v1/Chassis/1/Boards/' .. board.NodeId
            end
            item_list[1] = item
            return item_list
        end
    end
end
if map[id_table[1]] and not string.match(id, 'PSU') then
    local root_path = '/redfish/v1/Chassis/1/Boards/'
    local position = id_table[#id_table]
    local slot = tonumber(string.sub(position, -4, -3)) -- 获取上一层position
    local board_path = string.format('%s%s%s%s', id_table[1], slot, map[id_table[1]], slot)
    item['@odata.id'] = root_path .. board_path
    item_list[1] = item
    return item_list
end

local psu_slot = string.match(id, "PSU(%d+)")
if psu_slot then
    item['@odata.id'] = '/redfish/v1/Chassis/1/Power#/PowerSupplies/' .. (tonumber(psu_slot) - 1)
    item_list[1] = item
    return item_list
end

item['@odata.id'] = "/redfish/v1/Managers/1"
item_list[1] = item

return item_list