-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local rmcp_cipher_suits = Input
if rmcp_cipher_suits == nil then
    return
end

local id_to_key = {
    [1] = 'CipherSuite1',
    [2] = 'CipherSuite2',
    [3] = 'CipherSuite3',
    [17] = 'CipherSuite17',
}

local suits_rsp = cjson.json_object_new_object()
table.sort(rmcp_cipher_suits, function (a, b) return a.SuitId < b.SuitId end)
for _, v in pairs(rmcp_cipher_suits) do
    local key = id_to_key[v.SuitId]
    suits_rsp[key] = cjson.json_object_new_object()
    suits_rsp[key].Enabled = v.Enabled
    suits_rsp[key].AuthenticationAlgorithm = v.AuthenticationAlgorithm
    suits_rsp[key].IntegrityAlgorithm = v.IntegrityAlgorithm
    suits_rsp[key].ConfidentialityAlgorithm = v.ConfidentialityAlgorithm
end

return suits_rsp
