-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local function is_valid_foramt(format)
    if not format then
        return false
    end
    local valid_format = {'xml', 'dat', 'XML', 'DAT'}
    for _, v in ipairs(valid_format) do
        if format == v then
            return true
        end
    end
    return false
end

local function is_valid_protocol(protocol)
    if not protocol then
        return false
    end
    local valid_protocol = {'https', 'sftp', 'nfs', 'cifs', 'scp'}
    for _, v in ipairs(valid_protocol) do
        if protocol == v then
            return true
        end
    end
    return false
end

local function is_valid_remote_uri(uri)
    local protocol, format = string.match(uri, '(.*)://.*%.(.*)')
    return is_valid_protocol(protocol) and is_valid_foramt(format)
end

local function is_valid_local_uri(uri)
    return is_valid_foramt(string.match(uri, '^/tmp/.*%.(.*)'))
end

local function is_valid_uri(uri)
    return is_valid_local_uri(uri) or is_valid_remote_uri(uri)
end

if not is_valid_uri(ReqBody.Content) then
    error(custom_messages.IllegalContentBody())
end

return true