-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local hide_payload = ProcessingFlow[1].Destination.HidePayload
if hide_payload then
    return lua_nil
end
local payload = {}
local json_body = ProcessingFlow[1].Destination.JsonBody
if not json_body or #json_body == 0 then
    payload.JsonBody = ''
    return payload
end

local input = cjson.json_object_ordered_decode(json_body)
local data = ProcessingFlow[4].Destination.Data
local sensitive_properties = {}
local tmp
if data then
    for _, job in ipairs(data) do
        tmp = cjson.decode(job)
        if tmp.PayloadParams and tmp.PayloadParams.SensitiveProperties then
            for _, value in ipairs(tmp.PayloadParams.SensitiveProperties) do
                sensitive_properties[value] = true
            end
        end
    end
end

if next(sensitive_properties) == nil then
    payload.JsonBody = json_body
    return payload
end

local function process_sensitive_data(_input, _sensitive_properties)
    for key, value in pairs(_input) do
        if type(value) == "userdata" then
            process_sensitive_data(value, _sensitive_properties)
            goto continue
        end
        if _sensitive_properties[key] then
            _input[key] = '******'
        end
        ::continue::
    end
end

process_sensitive_data(input, sensitive_properties)

payload.JsonBody = cjson.json_object_ordered_encode(input)
return payload
