-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local model = ProcessingFlow[8].Destination.Model
local network_adapter_id = ProcessingFlow[8].Destination.ID
local network_port_lanes = ProcessingFlow[13].Destination.NetworkPortLanes
local port_id = Input
local port_list = {}
local port_exist = {}
local uri_template = '/redfish/v1/Chassis/1/NetworkAdapters/%s/NetworkPorts/%s'
if string.match(model, 'NPU') then
    for _, v in ipairs(network_port_lanes) do
        local port = v[1] + 1
        if not port_exist[port] then
            port_list[#port_list+1] = string.format(uri_template, network_adapter_id, port)
            port_exist[port] = true
        end
    end
    table.sort(port_list)
else
    port_list[1] = string.format(uri_template, network_adapter_id, port_id + 1)
end

return port_list