-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local type = {
    [0] = nil,
    [1] = 'RAID Card',
    [2] = 'Net Card',
    [3] = 'GPU Card',
    [4] = 'Storage Card',
    [5] = 'SDI Card',
    [6] = 'Accelerate Card',
    [7] = 'PCIe Riser Card',
    [8] = 'FPGA Card',
    [9] = 'NPU Card',
    [11] = 'DPU Card'
}

local PCIeType = {
    [0] = nil,
    [1] = 'RAID',
    [2] = 'NIC',
    [3] = 'GPU',
    [4] = 'SAS',
    [5] = 'SDI',
    [6] = 'Accelerate',
    [7] = 'Riser',
    [8] = 'FPGA',
    [9] = 'NPU',
    [10] = 'IB',
    [11] = 'DPU'
}

local BootOption = {
    [0] = 'None',
    [1] = 'Base Board PXE Boot',
    [2] = 'HDD Boot'
}

local obj = cjson.json_object_new_object()
obj.DeviceLocator = ProcessingFlow[2].Destination.DeviceName
obj.SlotNumber = ProcessingFlow[2].Destination.SlotID
obj.Position = ProcessingFlow[2].Destination.Position
if ProcessingFlow[2].Destination.FunctionClass == 5 or ProcessingFlow[2].Destination.FunctionClass == 11 then
    obj.Power = ProcessingFlow[4].Destination.PowerWatts / 10
    obj.McuFirmwareVersion = ProcessingFlow[3].Destination.MCUVersion
    obj.VrdFirmwareVersion = ProcessingFlow[3].Destination.VrdVersion
    obj.ChipTemperatureCelsius = cjson.json_object_new_array()
    obj.ChipTemperatureCelsius[1] = ProcessingFlow[4].Destination.CPUTemperatureCelsius
    obj.ChipTemperatureCelsius[2] = ProcessingFlow[4].Destination.Inlet1TemperatureCelsius
    obj.ChipTemperatureCelsius[3] = ProcessingFlow[4].Destination.Outlet1TemperatureCelsius
    obj.ChipTemperatureCelsius[4] = ProcessingFlow[4].Destination.SFP1TemperatureCelsius
    obj.ChipTemperatureCelsius[5] = ProcessingFlow[4].Destination.SFP2TemperatureCelsius
end
obj.FunctionType = type[ProcessingFlow[2].Destination.FunctionClass]
obj.PCIeCardType = PCIeType[ProcessingFlow[2].Destination.FunctionClass]
obj.ProductName = ProcessingFlow[2].Destination.BoardName
if ProcessingFlow[2].Destination.BoardID == 65535 then
    obj.BoardId = cjson.null
else
    obj.BoardId = string.format('0x%04x', ProcessingFlow[2].Destination.BoardID)
end
obj.PCBVersion = ProcessingFlow[2].Destination.PcbVersion
if ProcessingFlow[2].Destination.FunctionClass == 5 or ProcessingFlow[2].Destination.FunctionClass == 11 then
    obj.CSRVersion = ProcessingFlow[3].Destination.SRVersion
    obj.ComponentUniqueID = ProcessingFlow[3].Destination.UID
    obj.MRCLogLevel = ProcessingFlow[3].Destination.MRCLogLevel
    obj.UEFILogLevel = ProcessingFlow[3].Destination.UEFILogLevel
    obj.M2Device1Presence = (ProcessingFlow[3].Destination.M2SlotPresence & 0x01) ~= 0
    obj.M2Device2Presence = (ProcessingFlow[3].Destination.M2SlotPresence & 0x02) ~= 0
    obj.StorageManagementIP = ProcessingFlow[3].Destination.StorageIpAddr
    obj.StorageManagementVlanId = ProcessingFlow[3].Destination.StorageIpVlan ~= 0 and
        ProcessingFlow[3].Destination.StorageIpVlan or cjson.null
    obj.BootOption = BootOption[ProcessingFlow[3].Destination.BootSourceOverrideMode]
    obj.PxeOption = ProcessingFlow[3].Destination.PxeOption
    obj.SecureBoot = ProcessingFlow[10].Destination.SecureBootOptionEnabled and 'Enable' or 'Disable'
    obj.BootEffective = ProcessingFlow[3].Destination.BootSourceOverrideEnabled == 1 and 'Permanent' or 'One-time'
    obj.ExtendCardInfo = Input
end

if ProcessingFlow[2].Destination.FunctionClass == 9 then
    obj.Power = ProcessingFlow[7].Destination.PowerWatts >= 16384 and
        cjson.null or ProcessingFlow[7].Destination.PowerWatts / 10
    obj.McuFirmwareVersion = ProcessingFlow[7].Destination.McuFirmwareVersion
    obj.MemoryCapacityMB = ProcessingFlow[7].Destination.MemoryCapacityMiB
    obj.ChipTemperatureCelsius = cjson.json_object_new_array()
    obj.ChipTemperatureCelsius[1] = ProcessingFlow[7].Destination.Core0TemperatureCelsius >= 32765 and
        cjson.null or ProcessingFlow[7].Destination.Core0TemperatureCelsius
end

return obj
