-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local function format_data(data)
    if data == 65535 or data == nil then
        return cjson.null
    end
    return tonumber(string.format("%.4f", data))
end

local tx_bias = {}
local current = ProcessingFlow[6].Destination.TXBiasCurrentMilliAmps
for i in pairs(current) do
    local temp = {
        ReadingMilliAmperes = format_data(current[i]),
        LowerThresholdCritical = format_data(ProcessingFlow[6].Destination.TXLowerThresholdCritical),
        UpperThresholdCritical = format_data(ProcessingFlow[6].Destination.TXUpperThresholdCritical)
    }
    table.insert(tx_bias, temp)
end
return tx_bias