-- Copyright (c) 2025 Huawei Technologies Co., Ltd.	
-- openUBMC is licensed under Mulan PSL v2.	
-- You can use this software according to the terms and conditions of the Mulan PSL v2.	
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2	
--	
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,	
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,	
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.	
-- See the Mulan PSL v2 for more details.	

local processor_ports = Input
local processor_exit = {}
local processor_list = {}
local id
local processor_id
for _, v in pairs(processor_ports) do
    if not processor_exit[v[1]] and string.match(v[1], 'NPU') then
        id = string.lower(v[1])
        local a, b = string.match(id, 'npu(%d+)%-(%d+)')
        if a and b then
            processor_id = 2*tonumber(a) + tonumber(b) -2
        else
            a = string.match(id, 'npu(%d+)')
            processor_id = tonumber(a)
        end
        processor_list[#processor_list+1] = string.format('%s/%s', processor_id, v[1])
        processor_exit[v[1]] = true
    end
end

return processor_list